/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.QueryLoggingConfig;
import software.amazon.awssdk.services.route53.model.QueryLoggingConfigsCopier;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueryLoggingConfigsResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListQueryLoggingConfigsResponse> {
    private static final SdkField<List<QueryLoggingConfig>> QUERY_LOGGING_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListQueryLoggingConfigsResponse.getter(ListQueryLoggingConfigsResponse::queryLoggingConfigs)).setter(ListQueryLoggingConfigsResponse.setter(Builder::queryLoggingConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryLoggingConfigs").unmarshallLocationName("QueryLoggingConfigs").build(), ListTrait.builder().memberLocationName("QueryLoggingConfig").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryLoggingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryLoggingConfig").unmarshallLocationName("QueryLoggingConfig").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListQueryLoggingConfigsResponse.getter(ListQueryLoggingConfigsResponse::nextToken)).setter(ListQueryLoggingConfigsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_LOGGING_CONFIGS_FIELD, NEXT_TOKEN_FIELD));
    private final List<QueryLoggingConfig> queryLoggingConfigs;
    private final String nextToken;

    private ListQueryLoggingConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.queryLoggingConfigs = builder.queryLoggingConfigs;
        this.nextToken = builder.nextToken;
    }

    public boolean hasQueryLoggingConfigs() {
        return this.queryLoggingConfigs != null && !(this.queryLoggingConfigs instanceof SdkAutoConstructList);
    }

    public List<QueryLoggingConfig> queryLoggingConfigs() {
        return this.queryLoggingConfigs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryLoggingConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueryLoggingConfigsResponse)) {
            return false;
        }
        ListQueryLoggingConfigsResponse other = (ListQueryLoggingConfigsResponse)((Object)obj);
        return Objects.equals(this.queryLoggingConfigs(), other.queryLoggingConfigs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListQueryLoggingConfigsResponse").add("QueryLoggingConfigs", this.queryLoggingConfigs()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryLoggingConfigs": {
                return Optional.ofNullable(clazz.cast(this.queryLoggingConfigs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQueryLoggingConfigsResponse, T> g) {
        return obj -> g.apply((ListQueryLoggingConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private List<QueryLoggingConfig> queryLoggingConfigs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueryLoggingConfigsResponse model) {
            super(model);
            this.queryLoggingConfigs(model.queryLoggingConfigs);
            this.nextToken(model.nextToken);
        }

        public final Collection<QueryLoggingConfig.Builder> getQueryLoggingConfigs() {
            return this.queryLoggingConfigs != null ? (Collection)this.queryLoggingConfigs.stream().map(QueryLoggingConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queryLoggingConfigs(Collection<QueryLoggingConfig> queryLoggingConfigs) {
            this.queryLoggingConfigs = QueryLoggingConfigsCopier.copy(queryLoggingConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryLoggingConfigs(QueryLoggingConfig ... queryLoggingConfigs) {
            this.queryLoggingConfigs(Arrays.asList(queryLoggingConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryLoggingConfigs(Consumer<QueryLoggingConfig.Builder> ... queryLoggingConfigs) {
            this.queryLoggingConfigs(Stream.of(queryLoggingConfigs).map(c -> (QueryLoggingConfig)((QueryLoggingConfig.Builder)QueryLoggingConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQueryLoggingConfigs(Collection<QueryLoggingConfig.BuilderImpl> queryLoggingConfigs) {
            this.queryLoggingConfigs = QueryLoggingConfigsCopier.copyFromBuilder(queryLoggingConfigs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListQueryLoggingConfigsResponse build() {
            return new ListQueryLoggingConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQueryLoggingConfigsResponse> {
        public Builder queryLoggingConfigs(Collection<QueryLoggingConfig> var1);

        public Builder queryLoggingConfigs(QueryLoggingConfig ... var1);

        public Builder queryLoggingConfigs(Consumer<QueryLoggingConfig.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

