/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.ChangeInfo;
import software.amazon.awssdk.services.route53.model.DelegationSet;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.services.route53.model.VPC;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHostedZoneResponse
extends Route53Response
implements ToCopyableBuilder<Builder, CreateHostedZoneResponse> {
    private static final SdkField<HostedZone> HOSTED_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateHostedZoneResponse.getter(CreateHostedZoneResponse::hostedZone)).setter(CreateHostedZoneResponse.setter(Builder::hostedZone)).constructor(HostedZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZone").unmarshallLocationName("HostedZone").build()}).build();
    private static final SdkField<ChangeInfo> CHANGE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateHostedZoneResponse.getter(CreateHostedZoneResponse::changeInfo)).setter(CreateHostedZoneResponse.setter(Builder::changeInfo)).constructor(ChangeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeInfo").unmarshallLocationName("ChangeInfo").build()}).build();
    private static final SdkField<DelegationSet> DELEGATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateHostedZoneResponse.getter(CreateHostedZoneResponse::delegationSet)).setter(CreateHostedZoneResponse.setter(Builder::delegationSet)).constructor(DelegationSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationSet").unmarshallLocationName("DelegationSet").build()}).build();
    private static final SdkField<VPC> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateHostedZoneResponse.getter(CreateHostedZoneResponse::vpc)).setter(CreateHostedZoneResponse.setter(Builder::vpc)).constructor(VPC::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPC").unmarshallLocationName("VPC").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateHostedZoneResponse.getter(CreateHostedZoneResponse::location)).setter(CreateHostedZoneResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location").unmarshallLocationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_FIELD, CHANGE_INFO_FIELD, DELEGATION_SET_FIELD, VPC_FIELD, LOCATION_FIELD));
    private final HostedZone hostedZone;
    private final ChangeInfo changeInfo;
    private final DelegationSet delegationSet;
    private final VPC vpc;
    private final String location;

    private CreateHostedZoneResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZone = builder.hostedZone;
        this.changeInfo = builder.changeInfo;
        this.delegationSet = builder.delegationSet;
        this.vpc = builder.vpc;
        this.location = builder.location;
    }

    public HostedZone hostedZone() {
        return this.hostedZone;
    }

    public ChangeInfo changeInfo() {
        return this.changeInfo;
    }

    public DelegationSet delegationSet() {
        return this.delegationSet;
    }

    public VPC vpc() {
        return this.vpc;
    }

    public String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.delegationSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHostedZoneResponse)) {
            return false;
        }
        CreateHostedZoneResponse other = (CreateHostedZoneResponse)((Object)obj);
        return Objects.equals(this.hostedZone(), other.hostedZone()) && Objects.equals(this.changeInfo(), other.changeInfo()) && Objects.equals(this.delegationSet(), other.delegationSet()) && Objects.equals(this.vpc(), other.vpc()) && Objects.equals(this.location(), other.location());
    }

    public String toString() {
        return ToString.builder((String)"CreateHostedZoneResponse").add("HostedZone", (Object)this.hostedZone()).add("ChangeInfo", (Object)this.changeInfo()).add("DelegationSet", (Object)this.delegationSet()).add("VPC", (Object)this.vpc()).add("Location", (Object)this.location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZone": {
                return Optional.ofNullable(clazz.cast(this.hostedZone()));
            }
            case "ChangeInfo": {
                return Optional.ofNullable(clazz.cast(this.changeInfo()));
            }
            case "DelegationSet": {
                return Optional.ofNullable(clazz.cast(this.delegationSet()));
            }
            case "VPC": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHostedZoneResponse, T> g) {
        return obj -> g.apply((CreateHostedZoneResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private HostedZone hostedZone;
        private ChangeInfo changeInfo;
        private DelegationSet delegationSet;
        private VPC vpc;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHostedZoneResponse model) {
            super(model);
            this.hostedZone(model.hostedZone);
            this.changeInfo(model.changeInfo);
            this.delegationSet(model.delegationSet);
            this.vpc(model.vpc);
            this.location(model.location);
        }

        public final HostedZone.Builder getHostedZone() {
            return this.hostedZone != null ? this.hostedZone.toBuilder() : null;
        }

        @Override
        public final Builder hostedZone(HostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        public final void setHostedZone(HostedZone.BuilderImpl hostedZone) {
            this.hostedZone = hostedZone != null ? hostedZone.build() : null;
        }

        public final ChangeInfo.Builder getChangeInfo() {
            return this.changeInfo != null ? this.changeInfo.toBuilder() : null;
        }

        @Override
        public final Builder changeInfo(ChangeInfo changeInfo) {
            this.changeInfo = changeInfo;
            return this;
        }

        public final void setChangeInfo(ChangeInfo.BuilderImpl changeInfo) {
            this.changeInfo = changeInfo != null ? changeInfo.build() : null;
        }

        public final DelegationSet.Builder getDelegationSet() {
            return this.delegationSet != null ? this.delegationSet.toBuilder() : null;
        }

        @Override
        public final Builder delegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
            return this;
        }

        public final void setDelegationSet(DelegationSet.BuilderImpl delegationSet) {
            this.delegationSet = delegationSet != null ? delegationSet.build() : null;
        }

        public final VPC.Builder getVPC() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(VPC vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVPC(VPC.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public CreateHostedZoneResponse build() {
            return new CreateHostedZoneResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHostedZoneResponse> {
        public Builder hostedZone(HostedZone var1);

        default public Builder hostedZone(Consumer<HostedZone.Builder> hostedZone) {
            return this.hostedZone((HostedZone)((HostedZone.Builder)HostedZone.builder().applyMutation(hostedZone)).build());
        }

        public Builder changeInfo(ChangeInfo var1);

        default public Builder changeInfo(Consumer<ChangeInfo.Builder> changeInfo) {
            return this.changeInfo((ChangeInfo)((ChangeInfo.Builder)ChangeInfo.builder().applyMutation(changeInfo)).build());
        }

        public Builder delegationSet(DelegationSet var1);

        default public Builder delegationSet(Consumer<DelegationSet.Builder> delegationSet) {
            return this.delegationSet((DelegationSet)((DelegationSet.Builder)DelegationSet.builder().applyMutation(delegationSet)).build());
        }

        public Builder vpc(VPC var1);

        default public Builder vpc(Consumer<VPC.Builder> vpc) {
            return this.vpc((VPC)((VPC.Builder)VPC.builder().applyMutation(vpc)).build());
        }

        public Builder location(String var1);
    }
}

