/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.ReusableDelegationSetLimitType;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReusableDelegationSetLimitRequest
extends Route53Request
implements ToCopyableBuilder<Builder, GetReusableDelegationSetLimitRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetReusableDelegationSetLimitRequest.getter(GetReusableDelegationSetLimitRequest::typeAsString)).setter(GetReusableDelegationSetLimitRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Type").unmarshallLocationName("Type").build()}).build();
    private static final SdkField<String> DELEGATION_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetReusableDelegationSetLimitRequest.getter(GetReusableDelegationSetLimitRequest::delegationSetId)).setter(GetReusableDelegationSetLimitRequest.setter(Builder::delegationSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, DELEGATION_SET_ID_FIELD));
    private final String type;
    private final String delegationSetId;

    private GetReusableDelegationSetLimitRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.delegationSetId = builder.delegationSetId;
    }

    public ReusableDelegationSetLimitType type() {
        return ReusableDelegationSetLimitType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String delegationSetId() {
        return this.delegationSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.delegationSetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReusableDelegationSetLimitRequest)) {
            return false;
        }
        GetReusableDelegationSetLimitRequest other = (GetReusableDelegationSetLimitRequest)((Object)obj);
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.delegationSetId(), other.delegationSetId());
    }

    public String toString() {
        return ToString.builder((String)"GetReusableDelegationSetLimitRequest").add("Type", (Object)this.typeAsString()).add("DelegationSetId", (Object)this.delegationSetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "DelegationSetId": {
                return Optional.ofNullable(clazz.cast(this.delegationSetId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReusableDelegationSetLimitRequest, T> g) {
        return obj -> g.apply((GetReusableDelegationSetLimitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String type;
        private String delegationSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReusableDelegationSetLimitRequest model) {
            super(model);
            this.type(model.type);
            this.delegationSetId(model.delegationSetId);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ReusableDelegationSetLimitType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDelegationSetId() {
            return this.delegationSetId;
        }

        @Override
        public final Builder delegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
            return this;
        }

        public final void setDelegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReusableDelegationSetLimitRequest build() {
            return new GetReusableDelegationSetLimitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReusableDelegationSetLimitRequest> {
        public Builder type(String var1);

        public Builder type(ReusableDelegationSetLimitType var1);

        public Builder delegationSetId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

