/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.model.GlueIpListCopier;
import software.amazon.awssdk.services.route53domains.transform.NameserverMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Nameserver
implements StructuredPojo,
ToCopyableBuilder<Builder, Nameserver> {
    private final String name;
    private final List<String> glueIps;

    private Nameserver(BuilderImpl builder) {
        this.name = builder.name;
        this.glueIps = builder.glueIps;
    }

    public String name() {
        return this.name;
    }

    public List<String> glueIps() {
        return this.glueIps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueIps());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Nameserver)) {
            return false;
        }
        Nameserver other = (Nameserver)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.glueIps(), other.glueIps());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.glueIps() != null) {
            sb.append("GlueIps: ").append(this.glueIps()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "GlueIps": {
                return Optional.of(clazz.cast(this.glueIps()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NameserverMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> glueIps;

        private BuilderImpl() {
        }

        private BuilderImpl(Nameserver model) {
            this.name(model.name);
            this.glueIps(model.glueIps);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getGlueIps() {
            return this.glueIps;
        }

        @Override
        public final Builder glueIps(Collection<String> glueIps) {
            this.glueIps = GlueIpListCopier.copy(glueIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glueIps(String ... glueIps) {
            this.glueIps(Arrays.asList(glueIps));
            return this;
        }

        public final void setGlueIps(Collection<String> glueIps) {
            this.glueIps = GlueIpListCopier.copy(glueIps);
        }

        public Nameserver build() {
            return new Nameserver(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Nameserver> {
        public Builder name(String var1);

        public Builder glueIps(Collection<String> var1);

        public Builder glueIps(String ... var1);
    }
}

