/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.route53domains.model.DomainSuggestion;
import software.amazon.awssdk.services.route53domains.model.DomainSuggestionsListCopier;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDomainSuggestionsResponse
extends Route53DomainsResponse
implements ToCopyableBuilder<Builder, GetDomainSuggestionsResponse> {
    private final List<DomainSuggestion> suggestionsList;

    private GetDomainSuggestionsResponse(BuilderImpl builder) {
        super(builder);
        this.suggestionsList = builder.suggestionsList;
    }

    public List<DomainSuggestion> suggestionsList() {
        return this.suggestionsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.suggestionsList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainSuggestionsResponse)) {
            return false;
        }
        GetDomainSuggestionsResponse other = (GetDomainSuggestionsResponse)((Object)obj);
        return Objects.equals(this.suggestionsList(), other.suggestionsList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.suggestionsList() != null) {
            sb.append("SuggestionsList: ").append(this.suggestionsList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuggestionsList": {
                return Optional.of(clazz.cast(this.suggestionsList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53DomainsResponse.BuilderImpl
    implements Builder {
        private List<DomainSuggestion> suggestionsList;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainSuggestionsResponse model) {
            this.suggestionsList(model.suggestionsList);
        }

        public final Collection<DomainSuggestion.Builder> getSuggestionsList() {
            return this.suggestionsList != null ? (Collection)this.suggestionsList.stream().map(DomainSuggestion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder suggestionsList(Collection<DomainSuggestion> suggestionsList) {
            this.suggestionsList = DomainSuggestionsListCopier.copy(suggestionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestionsList(DomainSuggestion ... suggestionsList) {
            this.suggestionsList(Arrays.asList(suggestionsList));
            return this;
        }

        public final void setSuggestionsList(Collection<DomainSuggestion.BuilderImpl> suggestionsList) {
            this.suggestionsList = DomainSuggestionsListCopier.copyFromBuilder(suggestionsList);
        }

        @Override
        public GetDomainSuggestionsResponse build() {
            return new GetDomainSuggestionsResponse(this);
        }
    }

    public static interface Builder
    extends Route53DomainsResponse.Builder,
    CopyableBuilder<Builder, GetDomainSuggestionsResponse> {
        public Builder suggestionsList(Collection<DomainSuggestion> var1);

        public Builder suggestionsList(DomainSuggestion ... var1);
    }
}

