/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.HostedZonesCopier;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListHostedZonesByNameResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListHostedZonesByNameResponse> {
    private final List<HostedZone> hostedZones;
    private final String dnsName;
    private final String hostedZoneId;
    private final Boolean isTruncated;
    private final String nextDNSName;
    private final String nextHostedZoneId;
    private final String maxItems;

    private ListHostedZonesByNameResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZones = builder.hostedZones;
        this.dnsName = builder.dnsName;
        this.hostedZoneId = builder.hostedZoneId;
        this.isTruncated = builder.isTruncated;
        this.nextDNSName = builder.nextDNSName;
        this.nextHostedZoneId = builder.nextHostedZoneId;
        this.maxItems = builder.maxItems;
    }

    public List<HostedZone> hostedZones() {
        return this.hostedZones;
    }

    public String dnsName() {
        return this.dnsName;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String nextDNSName() {
        return this.nextDNSName;
    }

    public String nextHostedZoneId() {
        return this.nextHostedZoneId;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextDNSName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextHostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesByNameResponse)) {
            return false;
        }
        ListHostedZonesByNameResponse other = (ListHostedZonesByNameResponse)((Object)obj);
        return Objects.equals(this.hostedZones(), other.hostedZones()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.nextDNSName(), other.nextDNSName()) && Objects.equals(this.nextHostedZoneId(), other.nextHostedZoneId()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hostedZones() != null) {
            sb.append("HostedZones: ").append(this.hostedZones()).append(",");
        }
        if (this.dnsName() != null) {
            sb.append("DNSName: ").append(this.dnsName()).append(",");
        }
        if (this.hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(this.hostedZoneId()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.nextDNSName() != null) {
            sb.append("NextDNSName: ").append(this.nextDNSName()).append(",");
        }
        if (this.nextHostedZoneId() != null) {
            sb.append("NextHostedZoneId: ").append(this.nextHostedZoneId()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZones": {
                return Optional.of(clazz.cast(this.hostedZones()));
            }
            case "DNSName": {
                return Optional.of(clazz.cast(this.dnsName()));
            }
            case "HostedZoneId": {
                return Optional.of(clazz.cast(this.hostedZoneId()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "NextDNSName": {
                return Optional.of(clazz.cast(this.nextDNSName()));
            }
            case "NextHostedZoneId": {
                return Optional.of(clazz.cast(this.nextHostedZoneId()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private List<HostedZone> hostedZones;
        private String dnsName;
        private String hostedZoneId;
        private Boolean isTruncated;
        private String nextDNSName;
        private String nextHostedZoneId;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesByNameResponse model) {
            this.hostedZones(model.hostedZones);
            this.dnsName(model.dnsName);
            this.hostedZoneId(model.hostedZoneId);
            this.isTruncated(model.isTruncated);
            this.nextDNSName(model.nextDNSName);
            this.nextHostedZoneId(model.nextHostedZoneId);
            this.maxItems(model.maxItems);
        }

        public final Collection<HostedZone.Builder> getHostedZones() {
            return this.hostedZones != null ? (Collection)this.hostedZones.stream().map(HostedZone::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hostedZones(Collection<HostedZone> hostedZones) {
            this.hostedZones = HostedZonesCopier.copy(hostedZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZones(HostedZone ... hostedZones) {
            this.hostedZones(Arrays.asList(hostedZones));
            return this;
        }

        public final void setHostedZones(Collection<HostedZone.BuilderImpl> hostedZones) {
            this.hostedZones = HostedZonesCopier.copyFromBuilder(hostedZones);
        }

        public final String getDNSName() {
            return this.dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDNSName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextDNSName() {
            return this.nextDNSName;
        }

        @Override
        public final Builder nextDNSName(String nextDNSName) {
            this.nextDNSName = nextDNSName;
            return this;
        }

        public final void setNextDNSName(String nextDNSName) {
            this.nextDNSName = nextDNSName;
        }

        public final String getNextHostedZoneId() {
            return this.nextHostedZoneId;
        }

        @Override
        public final Builder nextHostedZoneId(String nextHostedZoneId) {
            this.nextHostedZoneId = nextHostedZoneId;
            return this;
        }

        public final void setNextHostedZoneId(String nextHostedZoneId) {
            this.nextHostedZoneId = nextHostedZoneId;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListHostedZonesByNameResponse build() {
            return new ListHostedZonesByNameResponse(this);
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    CopyableBuilder<Builder, ListHostedZonesByNameResponse> {
        public Builder hostedZones(Collection<HostedZone> var1);

        public Builder hostedZones(HostedZone ... var1);

        public Builder dnsName(String var1);

        public Builder hostedZoneId(String var1);

        public Builder isTruncated(Boolean var1);

        public Builder nextDNSName(String var1);

        public Builder nextHostedZoneId(String var1);

        public Builder maxItems(String var1);
    }
}

