/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.internal;

import java.util.stream.Collectors;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.route53.model.AliasTarget;
import software.amazon.awssdk.services.route53.model.ChangeInfo;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.DelegationSet;
import software.amazon.awssdk.services.route53.model.DeleteHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.GetChangeResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.HealthCheck;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.ListHealthChecksResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesResponse;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsResponse;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;

public class Route53IdInterceptor
implements ExecutionInterceptor {
    public SdkResponse modifyResponse(Context.ModifyResponse context, ExecutionAttributes executionAttributes) {
        SdkResponse response = context.response();
        if (response instanceof ChangeResourceRecordSetsResponse) {
            ChangeResourceRecordSetsResponse result = (ChangeResourceRecordSetsResponse)response;
            return (SdkResponse)result.toBuilder().changeInfo(this.removePrefix(result.changeInfo())).build();
        }
        if (response instanceof CreateHostedZoneResponse) {
            CreateHostedZoneResponse result = (CreateHostedZoneResponse)response;
            return (SdkResponse)result.toBuilder().changeInfo(this.removePrefix(result.changeInfo())).hostedZone(this.removePrefix(result.hostedZone())).delegationSet(this.removePrefix(result.delegationSet())).build();
        }
        if (response instanceof DeleteHostedZoneResponse) {
            DeleteHostedZoneResponse result = (DeleteHostedZoneResponse)response;
            return (SdkResponse)result.toBuilder().changeInfo(this.removePrefix(result.changeInfo())).build();
        }
        if (response instanceof GetChangeResponse) {
            GetChangeResponse result = (GetChangeResponse)response;
            return (SdkResponse)result.toBuilder().changeInfo(this.removePrefix(result.changeInfo())).build();
        }
        if (response instanceof GetHostedZoneResponse) {
            GetHostedZoneResponse result = (GetHostedZoneResponse)response;
            return (SdkResponse)result.toBuilder().hostedZone(this.removePrefix(result.hostedZone())).delegationSet(this.removePrefix(result.delegationSet())).build();
        }
        if (response instanceof ListHostedZonesResponse) {
            ListHostedZonesResponse result = (ListHostedZonesResponse)response;
            return (SdkResponse)result.toBuilder().hostedZones(result.hostedZones().stream().map(this::removePrefix).collect(Collectors.toList())).build();
        }
        if (response instanceof ListResourceRecordSetsResponse) {
            ListResourceRecordSetsResponse result = (ListResourceRecordSetsResponse)response;
            return (SdkResponse)result.toBuilder().resourceRecordSets(result.resourceRecordSets().stream().map(this::removePrefix).collect(Collectors.toList())).build();
        }
        if (response instanceof CreateHealthCheckResponse) {
            CreateHealthCheckResponse result = (CreateHealthCheckResponse)response;
            return (SdkResponse)result.toBuilder().healthCheck(this.removePrefix(result.healthCheck())).build();
        }
        if (response instanceof GetHealthCheckResponse) {
            GetHealthCheckResponse result = (GetHealthCheckResponse)response;
            return (SdkResponse)result.toBuilder().healthCheck(this.removePrefix(result.healthCheck())).build();
        }
        if (response instanceof ListHealthChecksResponse) {
            ListHealthChecksResponse result = (ListHealthChecksResponse)response;
            return (SdkResponse)result.toBuilder().healthChecks(result.healthChecks().stream().map(this::removePrefix).collect(Collectors.toList())).build();
        }
        if (response instanceof CreateReusableDelegationSetResponse) {
            CreateReusableDelegationSetResponse result = (CreateReusableDelegationSetResponse)response;
            return (SdkResponse)result.toBuilder().delegationSet(this.removePrefix(result.delegationSet())).build();
        }
        if (response instanceof GetReusableDelegationSetResponse) {
            GetReusableDelegationSetResponse result = (GetReusableDelegationSetResponse)response;
            return (SdkResponse)result.toBuilder().delegationSet(this.removePrefix(result.delegationSet())).build();
        }
        if (response instanceof ListReusableDelegationSetsResponse) {
            ListReusableDelegationSetsResponse result = (ListReusableDelegationSetsResponse)response;
            return (SdkResponse)result.toBuilder().delegationSets(result.delegationSets().stream().map(this::removePrefix).collect(Collectors.toList())).build();
        }
        return response;
    }

    private ResourceRecordSet removePrefix(ResourceRecordSet rrset) {
        if (rrset == null) {
            return null;
        }
        return (ResourceRecordSet)rrset.toBuilder().aliasTarget(this.removePrefix(rrset.aliasTarget())).healthCheckId(this.removePrefix(rrset.healthCheckId())).setIdentifier(this.removePrefix(rrset.setIdentifier())).build();
    }

    private AliasTarget removePrefix(AliasTarget aliasTarget) {
        if (aliasTarget == null) {
            return null;
        }
        return (AliasTarget)aliasTarget.toBuilder().hostedZoneId(this.removePrefix(aliasTarget.hostedZoneId())).build();
    }

    private ChangeInfo removePrefix(ChangeInfo changeInfo) {
        if (changeInfo == null) {
            return null;
        }
        return (ChangeInfo)changeInfo.toBuilder().id(this.removePrefix(changeInfo.id())).build();
    }

    private HostedZone removePrefix(HostedZone hostedZone) {
        if (hostedZone == null) {
            return null;
        }
        return (HostedZone)hostedZone.toBuilder().id(this.removePrefix(hostedZone.id())).build();
    }

    private HealthCheck removePrefix(HealthCheck healthCheck) {
        if (healthCheck == null) {
            return null;
        }
        return (HealthCheck)healthCheck.toBuilder().id(this.removePrefix(healthCheck.id())).build();
    }

    private DelegationSet removePrefix(DelegationSet delegationSet) {
        if (delegationSet == null) {
            return null;
        }
        return (DelegationSet)delegationSet.toBuilder().id(this.removePrefix(delegationSet.id())).build();
    }

    private String removePrefix(String s) {
        if (s == null) {
            return null;
        }
        int lastIndex = s.lastIndexOf("/");
        if (lastIndex > 0) {
            return s.substring(lastIndex + 1);
        }
        return s;
    }
}

