/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.transform.DomainSuggestionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DomainSuggestion
implements StructuredPojo,
ToCopyableBuilder<Builder, DomainSuggestion> {
    private final String domainName;
    private final String availability;

    private DomainSuggestion(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.availability = builder.availability;
    }

    public String domainName() {
        return this.domainName;
    }

    public String availability() {
        return this.availability;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.availability() == null ? 0 : this.availability().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSuggestion)) {
            return false;
        }
        DomainSuggestion other = (DomainSuggestion)obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.availability() == null ^ this.availability() == null) {
            return false;
        }
        return other.availability() == null || other.availability().equals(this.availability());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.availability() != null) {
            sb.append("Availability: ").append(this.availability()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "Availability": {
                return Optional.of(clazz.cast(this.availability()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainSuggestionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String availability;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSuggestion model) {
            this.domainName(model.domainName);
            this.availability(model.availability);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getAvailability() {
            return this.availability;
        }

        @Override
        public final Builder availability(String availability) {
            this.availability = availability;
            return this;
        }

        public final void setAvailability(String availability) {
            this.availability = availability;
        }

        public DomainSuggestion build() {
            return new DomainSuggestion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DomainSuggestion> {
        public Builder domainName(String var1);

        public Builder availability(String var1);
    }
}

