/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.XmlWriter;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceRequest;

public class UpdateTrafficPolicyInstanceRequestMarshaller
implements Marshaller<Request<UpdateTrafficPolicyInstanceRequest>, UpdateTrafficPolicyInstanceRequest> {
    public Request<UpdateTrafficPolicyInstanceRequest> marshall(UpdateTrafficPolicyInstanceRequest updateTrafficPolicyInstanceRequest) {
        if (updateTrafficPolicyInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateTrafficPolicyInstanceRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/trafficpolicyinstance/{Id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", updateTrafficPolicyInstanceRequest.id());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("UpdateTrafficPolicyInstanceRequest");
            if (updateTrafficPolicyInstanceRequest.ttl() != null) {
                xmlWriter.startElement("TTL").value((Object)updateTrafficPolicyInstanceRequest.ttl()).endElement();
            }
            if (updateTrafficPolicyInstanceRequest.trafficPolicyId() != null) {
                xmlWriter.startElement("TrafficPolicyId").value(updateTrafficPolicyInstanceRequest.trafficPolicyId()).endElement();
            }
            if (updateTrafficPolicyInstanceRequest.trafficPolicyVersion() != null) {
                xmlWriter.startElement("TrafficPolicyVersion").value((Object)updateTrafficPolicyInstanceRequest.trafficPolicyVersion()).endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

