/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.route53.model.ListHealthChecksRequest;

public class ListHealthChecksRequestMarshaller
implements Marshaller<Request<ListHealthChecksRequest>, ListHealthChecksRequest> {
    public Request<ListHealthChecksRequest> marshall(ListHealthChecksRequest listHealthChecksRequest) {
        if (listHealthChecksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listHealthChecksRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/healthcheck";
        request.setResourcePath(uriResourcePath);
        if (listHealthChecksRequest.marker() != null) {
            request.addParameter("marker", StringUtils.fromString((String)listHealthChecksRequest.marker()));
        }
        if (listHealthChecksRequest.maxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString((String)listHealthChecksRequest.maxItems()));
        }
        return request;
    }
}

