/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.XmlWriter;
import software.amazon.awssdk.services.route53.model.DisassociateVPCFromHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.VPC;

public class DisassociateVPCFromHostedZoneRequestMarshaller
implements Marshaller<Request<DisassociateVPCFromHostedZoneRequest>, DisassociateVPCFromHostedZoneRequest> {
    public Request<DisassociateVPCFromHostedZoneRequest> marshall(DisassociateVPCFromHostedZoneRequest disassociateVPCFromHostedZoneRequest) {
        if (disassociateVPCFromHostedZoneRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)disassociateVPCFromHostedZoneRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/hostedzone/{Id}/disassociatevpc";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", disassociateVPCFromHostedZoneRequest.hostedZoneId());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("DisassociateVPCFromHostedZoneRequest");
            VPC vpc = disassociateVPCFromHostedZoneRequest.vpc();
            if (vpc != null) {
                xmlWriter.startElement("VPC");
                if (vpc.vpcRegionString() != null) {
                    xmlWriter.startElement("VPCRegion").value(vpc.vpcRegionString()).endElement();
                }
                if (vpc.vpcId() != null) {
                    xmlWriter.startElement("VPCId").value(vpc.vpcId()).endElement();
                }
                xmlWriter.endElement();
            }
            if (disassociateVPCFromHostedZoneRequest.comment() != null) {
                xmlWriter.startElement("Comment").value(disassociateVPCFromHostedZoneRequest.comment()).endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

