/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.Change;
import software.amazon.awssdk.services.route53.transform.ResourceRecordSetUnmarshaller;

public class ChangeUnmarshaller
implements Unmarshaller<Change, StaxUnmarshallerContext> {
    private static final ChangeUnmarshaller INSTANCE = new ChangeUnmarshaller();

    public Change unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Change.Builder change = Change.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Action", targetDepth)) {
                    change.action(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ResourceRecordSet", targetDepth)) continue;
                change.resourceRecordSet(ResourceRecordSetUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Change)change.build();
    }

    public static ChangeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

