/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.Change;
import software.amazon.awssdk.services.route53.model.ChangeBatch;
import software.amazon.awssdk.services.route53.transform.ChangeUnmarshaller;

public class ChangeBatchUnmarshaller
implements Unmarshaller<ChangeBatch, StaxUnmarshallerContext> {
    private static final ChangeBatchUnmarshaller INSTANCE = new ChangeBatchUnmarshaller();

    public ChangeBatch unmarshall(StaxUnmarshallerContext context) throws Exception {
        ChangeBatch.Builder changeBatch;
        block6: {
            changeBatch = ChangeBatch.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Change> changes = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    changeBatch.changes(changes);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Comment", targetDepth)) {
                        changeBatch.comment(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Changes", targetDepth)) {
                        changes = new ArrayList<Change>();
                        continue;
                    }
                    if (!context.testExpression("Changes/Change", targetDepth)) continue;
                    changes.add(ChangeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            changeBatch.changes(changes);
        }
        return (ChangeBatch)changeBatch.build();
    }

    public static ChangeBatchUnmarshaller getInstance() {
        return INSTANCE;
    }
}

