/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.route53.model.TrafficPoliciesCopier;
import software.amazon.awssdk.services.route53.model.TrafficPolicy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTrafficPolicyVersionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListTrafficPolicyVersionsResponse> {
    private final List<TrafficPolicy> trafficPolicies;
    private final Boolean isTruncated;
    private final String trafficPolicyVersionMarker;
    private final String maxItems;

    private ListTrafficPolicyVersionsResponse(BuilderImpl builder) {
        this.trafficPolicies = builder.trafficPolicies;
        this.isTruncated = builder.isTruncated;
        this.trafficPolicyVersionMarker = builder.trafficPolicyVersionMarker;
        this.maxItems = builder.maxItems;
    }

    public List<TrafficPolicy> trafficPolicies() {
        return this.trafficPolicies;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String trafficPolicyVersionMarker() {
        return this.trafficPolicyVersionMarker;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.trafficPolicies() == null ? 0 : this.trafficPolicies().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.trafficPolicyVersionMarker() == null ? 0 : this.trafficPolicyVersionMarker().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyVersionsResponse)) {
            return false;
        }
        ListTrafficPolicyVersionsResponse other = (ListTrafficPolicyVersionsResponse)((Object)obj);
        if (other.trafficPolicies() == null ^ this.trafficPolicies() == null) {
            return false;
        }
        if (other.trafficPolicies() != null && !other.trafficPolicies().equals(this.trafficPolicies())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.trafficPolicyVersionMarker() == null ^ this.trafficPolicyVersionMarker() == null) {
            return false;
        }
        if (other.trafficPolicyVersionMarker() != null && !other.trafficPolicyVersionMarker().equals(this.trafficPolicyVersionMarker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        return other.maxItems() == null || other.maxItems().equals(this.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.trafficPolicies() != null) {
            sb.append("TrafficPolicies: ").append(this.trafficPolicies()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.trafficPolicyVersionMarker() != null) {
            sb.append("TrafficPolicyVersionMarker: ").append(this.trafficPolicyVersionMarker()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficPolicies": {
                return Optional.of(clazz.cast(this.trafficPolicies()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "TrafficPolicyVersionMarker": {
                return Optional.of(clazz.cast(this.trafficPolicyVersionMarker()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<TrafficPolicy> trafficPolicies;
        private Boolean isTruncated;
        private String trafficPolicyVersionMarker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyVersionsResponse model) {
            this.trafficPolicies(model.trafficPolicies);
            this.isTruncated(model.isTruncated);
            this.trafficPolicyVersionMarker(model.trafficPolicyVersionMarker);
            this.maxItems(model.maxItems);
        }

        public final Collection<TrafficPolicy.Builder> getTrafficPolicies() {
            return this.trafficPolicies != null ? (Collection)this.trafficPolicies.stream().map(TrafficPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trafficPolicies(Collection<TrafficPolicy> trafficPolicies) {
            this.trafficPolicies = TrafficPoliciesCopier.copy(trafficPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficPolicies(TrafficPolicy ... trafficPolicies) {
            this.trafficPolicies(Arrays.asList(trafficPolicies));
            return this;
        }

        public final void setTrafficPolicies(Collection<TrafficPolicy.BuilderImpl> trafficPolicies) {
            this.trafficPolicies = TrafficPoliciesCopier.copyFromBuilder(trafficPolicies);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getTrafficPolicyVersionMarker() {
            return this.trafficPolicyVersionMarker;
        }

        @Override
        public final Builder trafficPolicyVersionMarker(String trafficPolicyVersionMarker) {
            this.trafficPolicyVersionMarker = trafficPolicyVersionMarker;
            return this;
        }

        public final void setTrafficPolicyVersionMarker(String trafficPolicyVersionMarker) {
            this.trafficPolicyVersionMarker = trafficPolicyVersionMarker;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public ListTrafficPolicyVersionsResponse build() {
            return new ListTrafficPolicyVersionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTrafficPolicyVersionsResponse> {
        public Builder trafficPolicies(Collection<TrafficPolicy> var1);

        public Builder trafficPolicies(TrafficPolicy ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder trafficPolicyVersionMarker(String var1);

        public Builder maxItems(String var1);
    }
}

