/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import software.amazon.awssdk.services.route53.model.HostedZoneConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HostedZone
implements ToCopyableBuilder<Builder, HostedZone> {
    private final String id;
    private final String name;
    private final String callerReference;
    private final HostedZoneConfig config;
    private final Long resourceRecordSetCount;

    private HostedZone(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.callerReference = builder.callerReference;
        this.config = builder.config;
        this.resourceRecordSetCount = builder.resourceRecordSetCount;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public HostedZoneConfig config() {
        return this.config;
    }

    public Long resourceRecordSetCount() {
        return this.resourceRecordSetCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.callerReference() == null ? 0 : this.callerReference().hashCode());
        hashCode = 31 * hashCode + (this.config() == null ? 0 : this.config().hashCode());
        hashCode = 31 * hashCode + (this.resourceRecordSetCount() == null ? 0 : this.resourceRecordSetCount().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostedZone)) {
            return false;
        }
        HostedZone other = (HostedZone)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.callerReference() == null ^ this.callerReference() == null) {
            return false;
        }
        if (other.callerReference() != null && !other.callerReference().equals(this.callerReference())) {
            return false;
        }
        if (other.config() == null ^ this.config() == null) {
            return false;
        }
        if (other.config() != null && !other.config().equals(this.config())) {
            return false;
        }
        if (other.resourceRecordSetCount() == null ^ this.resourceRecordSetCount() == null) {
            return false;
        }
        return other.resourceRecordSetCount() == null || other.resourceRecordSetCount().equals(this.resourceRecordSetCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.callerReference() != null) {
            sb.append("CallerReference: ").append(this.callerReference()).append(",");
        }
        if (this.config() != null) {
            sb.append("Config: ").append(this.config()).append(",");
        }
        if (this.resourceRecordSetCount() != null) {
            sb.append("ResourceRecordSetCount: ").append(this.resourceRecordSetCount()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "CallerReference": {
                return Optional.of(clazz.cast(this.callerReference()));
            }
            case "Config": {
                return Optional.of(clazz.cast(this.config()));
            }
            case "ResourceRecordSetCount": {
                return Optional.of(clazz.cast(this.resourceRecordSetCount()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String callerReference;
        private HostedZoneConfig config;
        private Long resourceRecordSetCount;

        private BuilderImpl() {
        }

        private BuilderImpl(HostedZone model) {
            this.id(model.id);
            this.name(model.name);
            this.callerReference(model.callerReference);
            this.config(model.config);
            this.resourceRecordSetCount(model.resourceRecordSetCount);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final HostedZoneConfig.Builder getConfig() {
            return this.config != null ? this.config.toBuilder() : null;
        }

        @Override
        public final Builder config(HostedZoneConfig config) {
            this.config = config;
            return this;
        }

        public final void setConfig(HostedZoneConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        public final Long getResourceRecordSetCount() {
            return this.resourceRecordSetCount;
        }

        @Override
        public final Builder resourceRecordSetCount(Long resourceRecordSetCount) {
            this.resourceRecordSetCount = resourceRecordSetCount;
            return this;
        }

        public final void setResourceRecordSetCount(Long resourceRecordSetCount) {
            this.resourceRecordSetCount = resourceRecordSetCount;
        }

        public HostedZone build() {
            return new HostedZone(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HostedZone> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder callerReference(String var1);

        public Builder config(HostedZoneConfig var1);

        public Builder resourceRecordSetCount(Long var1);
    }
}

