/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateReusableDelegationSetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateReusableDelegationSetRequest> {
    private final String callerReference;
    private final String hostedZoneId;

    private CreateReusableDelegationSetRequest(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.hostedZoneId = builder.hostedZoneId;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.callerReference() == null ? 0 : this.callerReference().hashCode());
        hashCode = 31 * hashCode + (this.hostedZoneId() == null ? 0 : this.hostedZoneId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReusableDelegationSetRequest)) {
            return false;
        }
        CreateReusableDelegationSetRequest other = (CreateReusableDelegationSetRequest)((Object)obj);
        if (other.callerReference() == null ^ this.callerReference() == null) {
            return false;
        }
        if (other.callerReference() != null && !other.callerReference().equals(this.callerReference())) {
            return false;
        }
        if (other.hostedZoneId() == null ^ this.hostedZoneId() == null) {
            return false;
        }
        return other.hostedZoneId() == null || other.hostedZoneId().equals(this.hostedZoneId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.callerReference() != null) {
            sb.append("CallerReference: ").append(this.callerReference()).append(",");
        }
        if (this.hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(this.hostedZoneId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallerReference": {
                return Optional.of(clazz.cast(this.callerReference()));
            }
            case "HostedZoneId": {
                return Optional.of(clazz.cast(this.hostedZoneId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String callerReference;
        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReusableDelegationSetRequest model) {
            this.callerReference(model.callerReference);
            this.hostedZoneId(model.hostedZoneId);
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public CreateReusableDelegationSetRequest build() {
            return new CreateReusableDelegationSetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateReusableDelegationSetRequest> {
        public Builder callerReference(String var1);

        public Builder hostedZoneId(String var1);
    }
}

