/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.services.route53.model.ChangeStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ChangeInfo
implements ToCopyableBuilder<Builder, ChangeInfo> {
    private final String id;
    private final String status;
    private final Instant submittedAt;
    private final String comment;

    private ChangeInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.submittedAt = builder.submittedAt;
        this.comment = builder.comment;
    }

    public String id() {
        return this.id;
    }

    public ChangeStatus status() {
        return ChangeStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Instant submittedAt() {
        return this.submittedAt;
    }

    public String comment() {
        return this.comment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.submittedAt() == null ? 0 : this.submittedAt().hashCode());
        hashCode = 31 * hashCode + (this.comment() == null ? 0 : this.comment().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeInfo)) {
            return false;
        }
        ChangeInfo other = (ChangeInfo)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.submittedAt() == null ^ this.submittedAt() == null) {
            return false;
        }
        if (other.submittedAt() != null && !other.submittedAt().equals(this.submittedAt())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        return other.comment() == null || other.comment().equals(this.comment());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.submittedAt() != null) {
            sb.append("SubmittedAt: ").append(this.submittedAt()).append(",");
        }
        if (this.comment() != null) {
            sb.append("Comment: ").append(this.comment()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "SubmittedAt": {
                return Optional.of(clazz.cast(this.submittedAt()));
            }
            case "Comment": {
                return Optional.of(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String status;
        private Instant submittedAt;
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeInfo model) {
            this.id(model.id);
            this.status(model.status);
            this.submittedAt(model.submittedAt);
            this.comment(model.comment);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getSubmittedAt() {
            return this.submittedAt;
        }

        @Override
        public final Builder submittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
            return this;
        }

        public final void setSubmittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public ChangeInfo build() {
            return new ChangeInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ChangeInfo> {
        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(ChangeStatus var1);

        public Builder submittedAt(Instant var1);

        public Builder comment(String var1);
    }
}

