/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.route53domains.model.BillingRecord;

@SdkInternalApi
public class BillingRecordMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").build();
    private static final MarshallingInfo<String> OPERATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Operation").build();
    private static final MarshallingInfo<String> INVOICEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InvoiceId").build();
    private static final MarshallingInfo<Instant> BILLDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BillDate").build();
    private static final MarshallingInfo<Double> PRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Price").build();
    private static final BillingRecordMarshaller INSTANCE = new BillingRecordMarshaller();

    public static BillingRecordMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BillingRecord billingRecord, ProtocolMarshaller protocolMarshaller) {
        if (billingRecord == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)billingRecord.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)billingRecord.operation(), OPERATION_BINDING);
            protocolMarshaller.marshall((Object)billingRecord.invoiceId(), INVOICEID_BINDING);
            protocolMarshaller.marshall((Object)billingRecord.billDate(), BILLDATE_BINDING);
            protocolMarshaller.marshall((Object)billingRecord.price(), PRICE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

