/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListTrafficPolicyInstancesRequestMarshaller
implements Marshaller<Request<ListTrafficPolicyInstancesRequest>, ListTrafficPolicyInstancesRequest> {
    public Request<ListTrafficPolicyInstancesRequest> marshall(ListTrafficPolicyInstancesRequest listTrafficPolicyInstancesRequest) {
        if (listTrafficPolicyInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listTrafficPolicyInstancesRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/trafficpolicyinstances";
        request.setResourcePath(uriResourcePath);
        if (listTrafficPolicyInstancesRequest.hostedZoneIdMarker() != null) {
            request.addParameter("hostedzoneid", StringUtils.fromString((String)listTrafficPolicyInstancesRequest.hostedZoneIdMarker()));
        }
        if (listTrafficPolicyInstancesRequest.trafficPolicyInstanceNameMarker() != null) {
            request.addParameter("trafficpolicyinstancename", StringUtils.fromString((String)listTrafficPolicyInstancesRequest.trafficPolicyInstanceNameMarker()));
        }
        if (listTrafficPolicyInstancesRequest.trafficPolicyInstanceTypeMarker() != null) {
            request.addParameter("trafficpolicyinstancetype", StringUtils.fromString((String)listTrafficPolicyInstancesRequest.trafficPolicyInstanceTypeMarker()));
        }
        if (listTrafficPolicyInstancesRequest.maxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString((String)listTrafficPolicyInstancesRequest.maxItems()));
        }
        return request;
    }
}

