/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListResourceRecordSetsRequestMarshaller
implements Marshaller<Request<ListResourceRecordSetsRequest>, ListResourceRecordSetsRequest> {
    public Request<ListResourceRecordSetsRequest> marshall(ListResourceRecordSetsRequest listResourceRecordSetsRequest) {
        if (listResourceRecordSetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listResourceRecordSetsRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/hostedzone/{Id}/rrset";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", listResourceRecordSetsRequest.hostedZoneId());
        request.setResourcePath(uriResourcePath);
        if (listResourceRecordSetsRequest.startRecordName() != null) {
            request.addParameter("name", StringUtils.fromString((String)listResourceRecordSetsRequest.startRecordName()));
        }
        if (listResourceRecordSetsRequest.startRecordType() != null) {
            request.addParameter("type", StringUtils.fromString((String)listResourceRecordSetsRequest.startRecordType()));
        }
        if (listResourceRecordSetsRequest.startRecordIdentifier() != null) {
            request.addParameter("identifier", StringUtils.fromString((String)listResourceRecordSetsRequest.startRecordIdentifier()));
        }
        if (listResourceRecordSetsRequest.maxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString((String)listResourceRecordSetsRequest.maxItems()));
        }
        return request;
    }
}

