/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import software.amazon.awssdk.services.route53.model.ChangeAction;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Change
implements ToCopyableBuilder<Builder, Change> {
    private final String action;
    private final ResourceRecordSet resourceRecordSet;

    private Change(BuilderImpl builder) {
        this.action = builder.action;
        this.resourceRecordSet = builder.resourceRecordSet;
    }

    public String action() {
        return this.action;
    }

    public ResourceRecordSet resourceRecordSet() {
        return this.resourceRecordSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        hashCode = 31 * hashCode + (this.resourceRecordSet() == null ? 0 : this.resourceRecordSet().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Change)) {
            return false;
        }
        Change other = (Change)obj;
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.resourceRecordSet() == null ^ this.resourceRecordSet() == null) {
            return false;
        }
        return other.resourceRecordSet() == null || other.resourceRecordSet().equals(this.resourceRecordSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.resourceRecordSet() != null) {
            sb.append("ResourceRecordSet: ").append(this.resourceRecordSet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String action;
        private ResourceRecordSet resourceRecordSet;

        private BuilderImpl() {
        }

        private BuilderImpl(Change model) {
            this.setAction(model.action);
            this.setResourceRecordSet(model.resourceRecordSet);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final ResourceRecordSet getResourceRecordSet() {
            return this.resourceRecordSet;
        }

        @Override
        public final Builder resourceRecordSet(ResourceRecordSet resourceRecordSet) {
            this.resourceRecordSet = resourceRecordSet;
            return this;
        }

        public final void setResourceRecordSet(ResourceRecordSet resourceRecordSet) {
            this.resourceRecordSet = resourceRecordSet;
        }

        public Change build() {
            return new Change(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Change> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder resourceRecordSet(ResourceRecordSet var1);
    }
}

