/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.route53domains.model.Nameserver;
import software.amazon.awssdk.services.route53domains.model.NameserverListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateDomainNameserversRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateDomainNameserversRequest> {
    private final String domainName;
    private final String fiAuthKey;
    private final List<Nameserver> nameservers;

    private UpdateDomainNameserversRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.fiAuthKey = builder.fiAuthKey;
        this.nameservers = builder.nameservers;
    }

    public String domainName() {
        return this.domainName;
    }

    public String fiAuthKey() {
        return this.fiAuthKey;
    }

    public List<Nameserver> nameservers() {
        return this.nameservers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.fiAuthKey() == null ? 0 : this.fiAuthKey().hashCode());
        hashCode = 31 * hashCode + (this.nameservers() == null ? 0 : this.nameservers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainNameserversRequest)) {
            return false;
        }
        UpdateDomainNameserversRequest other = (UpdateDomainNameserversRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.fiAuthKey() == null ^ this.fiAuthKey() == null) {
            return false;
        }
        if (other.fiAuthKey() != null && !other.fiAuthKey().equals(this.fiAuthKey())) {
            return false;
        }
        if (other.nameservers() == null ^ this.nameservers() == null) {
            return false;
        }
        return other.nameservers() == null || other.nameservers().equals(this.nameservers());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.fiAuthKey() != null) {
            sb.append("FIAuthKey: ").append(this.fiAuthKey()).append(",");
        }
        if (this.nameservers() != null) {
            sb.append("Nameservers: ").append(this.nameservers()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String fiAuthKey;
        private List<Nameserver> nameservers;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainNameserversRequest model) {
            this.setDomainName(model.domainName);
            this.setFIAuthKey(model.fiAuthKey);
            this.setNameservers(model.nameservers);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getFIAuthKey() {
            return this.fiAuthKey;
        }

        @Override
        public final Builder fiAuthKey(String fiAuthKey) {
            this.fiAuthKey = fiAuthKey;
            return this;
        }

        public final void setFIAuthKey(String fiAuthKey) {
            this.fiAuthKey = fiAuthKey;
        }

        public final Collection<Nameserver> getNameservers() {
            return this.nameservers;
        }

        @Override
        public final Builder nameservers(Collection<Nameserver> nameservers) {
            this.nameservers = NameserverListCopier.copy(nameservers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(Nameserver ... nameservers) {
            this.nameservers(Arrays.asList(nameservers));
            return this;
        }

        public final void setNameservers(Collection<Nameserver> nameservers) {
            this.nameservers = NameserverListCopier.copy(nameservers);
        }

        public UpdateDomainNameserversRequest build() {
            return new UpdateDomainNameserversRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateDomainNameserversRequest> {
        public Builder domainName(String var1);

        public Builder fiAuthKey(String var1);

        public Builder nameservers(Collection<Nameserver> var1);

        public Builder nameservers(Nameserver ... var1);
    }
}

