/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDomainSuggestionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetDomainSuggestionsRequest> {
    private final String domainName;
    private final Integer suggestionCount;
    private final Boolean onlyAvailable;

    private GetDomainSuggestionsRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.suggestionCount = builder.suggestionCount;
        this.onlyAvailable = builder.onlyAvailable;
    }

    public String domainName() {
        return this.domainName;
    }

    public Integer suggestionCount() {
        return this.suggestionCount;
    }

    public Boolean onlyAvailable() {
        return this.onlyAvailable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.suggestionCount() == null ? 0 : this.suggestionCount().hashCode());
        hashCode = 31 * hashCode + (this.onlyAvailable() == null ? 0 : this.onlyAvailable().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainSuggestionsRequest)) {
            return false;
        }
        GetDomainSuggestionsRequest other = (GetDomainSuggestionsRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.suggestionCount() == null ^ this.suggestionCount() == null) {
            return false;
        }
        if (other.suggestionCount() != null && !other.suggestionCount().equals(this.suggestionCount())) {
            return false;
        }
        if (other.onlyAvailable() == null ^ this.onlyAvailable() == null) {
            return false;
        }
        return other.onlyAvailable() == null || other.onlyAvailable().equals(this.onlyAvailable());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.suggestionCount() != null) {
            sb.append("SuggestionCount: ").append(this.suggestionCount()).append(",");
        }
        if (this.onlyAvailable() != null) {
            sb.append("OnlyAvailable: ").append(this.onlyAvailable()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String domainName;
        private Integer suggestionCount;
        private Boolean onlyAvailable;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainSuggestionsRequest model) {
            this.setDomainName(model.domainName);
            this.setSuggestionCount(model.suggestionCount);
            this.setOnlyAvailable(model.onlyAvailable);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Integer getSuggestionCount() {
            return this.suggestionCount;
        }

        @Override
        public final Builder suggestionCount(Integer suggestionCount) {
            this.suggestionCount = suggestionCount;
            return this;
        }

        public final void setSuggestionCount(Integer suggestionCount) {
            this.suggestionCount = suggestionCount;
        }

        public final Boolean getOnlyAvailable() {
            return this.onlyAvailable;
        }

        @Override
        public final Builder onlyAvailable(Boolean onlyAvailable) {
            this.onlyAvailable = onlyAvailable;
            return this;
        }

        public final void setOnlyAvailable(Boolean onlyAvailable) {
            this.onlyAvailable = onlyAvailable;
        }

        public GetDomainSuggestionsRequest build() {
            return new GetDomainSuggestionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetDomainSuggestionsRequest> {
        public Builder domainName(String var1);

        public Builder suggestionCount(Integer var1);

        public Builder onlyAvailable(Boolean var1);
    }
}

