/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.model.OperationType;
import software.amazon.awssdk.services.route53domains.transform.BillingRecordMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BillingRecord
implements StructuredPojo,
ToCopyableBuilder<Builder, BillingRecord> {
    private final String domainName;
    private final String operation;
    private final String invoiceId;
    private final Instant billDate;
    private final Double price;

    private BillingRecord(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.operation = builder.operation;
        this.invoiceId = builder.invoiceId;
        this.billDate = builder.billDate;
        this.price = builder.price;
    }

    public String domainName() {
        return this.domainName;
    }

    public String operation() {
        return this.operation;
    }

    public String invoiceId() {
        return this.invoiceId;
    }

    public Instant billDate() {
        return this.billDate;
    }

    public Double price() {
        return this.price;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.operation() == null ? 0 : this.operation().hashCode());
        hashCode = 31 * hashCode + (this.invoiceId() == null ? 0 : this.invoiceId().hashCode());
        hashCode = 31 * hashCode + (this.billDate() == null ? 0 : this.billDate().hashCode());
        hashCode = 31 * hashCode + (this.price() == null ? 0 : this.price().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingRecord)) {
            return false;
        }
        BillingRecord other = (BillingRecord)obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.operation() == null ^ this.operation() == null) {
            return false;
        }
        if (other.operation() != null && !other.operation().equals(this.operation())) {
            return false;
        }
        if (other.invoiceId() == null ^ this.invoiceId() == null) {
            return false;
        }
        if (other.invoiceId() != null && !other.invoiceId().equals(this.invoiceId())) {
            return false;
        }
        if (other.billDate() == null ^ this.billDate() == null) {
            return false;
        }
        if (other.billDate() != null && !other.billDate().equals(this.billDate())) {
            return false;
        }
        if (other.price() == null ^ this.price() == null) {
            return false;
        }
        return other.price() == null || other.price().equals(this.price());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.operation() != null) {
            sb.append("Operation: ").append(this.operation()).append(",");
        }
        if (this.invoiceId() != null) {
            sb.append("InvoiceId: ").append(this.invoiceId()).append(",");
        }
        if (this.billDate() != null) {
            sb.append("BillDate: ").append(this.billDate()).append(",");
        }
        if (this.price() != null) {
            sb.append("Price: ").append(this.price()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BillingRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String operation;
        private String invoiceId;
        private Instant billDate;
        private Double price;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingRecord model) {
            this.setDomainName(model.domainName);
            this.setOperation(model.operation);
            this.setInvoiceId(model.invoiceId);
            this.setBillDate(model.billDate);
            this.setPrice(model.price);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getOperation() {
            return this.operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(OperationType operation) {
            this.operation(operation.toString());
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public final String getInvoiceId() {
            return this.invoiceId;
        }

        @Override
        public final Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public final void setInvoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
        }

        public final Instant getBillDate() {
            return this.billDate;
        }

        @Override
        public final Builder billDate(Instant billDate) {
            this.billDate = billDate;
            return this;
        }

        public final void setBillDate(Instant billDate) {
            this.billDate = billDate;
        }

        public final Double getPrice() {
            return this.price;
        }

        @Override
        public final Builder price(Double price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Double price) {
            this.price = price;
        }

        public BillingRecord build() {
            return new BillingRecord(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BillingRecord> {
        public Builder domainName(String var1);

        public Builder operation(String var1);

        public Builder operation(OperationType var1);

        public Builder invoiceId(String var1);

        public Builder billDate(Instant var1);

        public Builder price(Double var1);
    }
}

