/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.time.Instant;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StatusReport
implements ToCopyableBuilder<Builder, StatusReport> {
    private final String status;
    private final Instant checkedTime;

    private StatusReport(BuilderImpl builder) {
        this.status = builder.status;
        this.checkedTime = builder.checkedTime;
    }

    public String status() {
        return this.status;
    }

    public Instant checkedTime() {
        return this.checkedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.checkedTime() == null ? 0 : this.checkedTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusReport)) {
            return false;
        }
        StatusReport other = (StatusReport)obj;
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.checkedTime() == null ^ this.checkedTime() == null) {
            return false;
        }
        return other.checkedTime() == null || other.checkedTime().equals(this.checkedTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.checkedTime() != null) {
            sb.append("CheckedTime: ").append(this.checkedTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String status;
        private Instant checkedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StatusReport model) {
            this.setStatus(model.status);
            this.setCheckedTime(model.checkedTime);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCheckedTime() {
            return this.checkedTime;
        }

        @Override
        public final Builder checkedTime(Instant checkedTime) {
            this.checkedTime = checkedTime;
            return this;
        }

        public final void setCheckedTime(Instant checkedTime) {
            this.checkedTime = checkedTime;
        }

        public StatusReport build() {
            return new StatusReport(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StatusReport> {
        public Builder status(String var1);

        public Builder checkedTime(Instant var1);
    }
}

