/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.route53.model.HostedZoneConfig;
import software.amazon.awssdk.services.route53.model.VPC;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateHostedZoneRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateHostedZoneRequest> {
    private final String name;
    private final VPC vpc;
    private final String callerReference;
    private final HostedZoneConfig hostedZoneConfig;
    private final String delegationSetId;

    private CreateHostedZoneRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.vpc = builder.vpc;
        this.callerReference = builder.callerReference;
        this.hostedZoneConfig = builder.hostedZoneConfig;
        this.delegationSetId = builder.delegationSetId;
    }

    public String name() {
        return this.name;
    }

    public VPC vpc() {
        return this.vpc;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public HostedZoneConfig hostedZoneConfig() {
        return this.hostedZoneConfig;
    }

    public String delegationSetId() {
        return this.delegationSetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.vpc() == null ? 0 : this.vpc().hashCode());
        hashCode = 31 * hashCode + (this.callerReference() == null ? 0 : this.callerReference().hashCode());
        hashCode = 31 * hashCode + (this.hostedZoneConfig() == null ? 0 : this.hostedZoneConfig().hashCode());
        hashCode = 31 * hashCode + (this.delegationSetId() == null ? 0 : this.delegationSetId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHostedZoneRequest)) {
            return false;
        }
        CreateHostedZoneRequest other = (CreateHostedZoneRequest)((Object)obj);
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.vpc() == null ^ this.vpc() == null) {
            return false;
        }
        if (other.vpc() != null && !other.vpc().equals(this.vpc())) {
            return false;
        }
        if (other.callerReference() == null ^ this.callerReference() == null) {
            return false;
        }
        if (other.callerReference() != null && !other.callerReference().equals(this.callerReference())) {
            return false;
        }
        if (other.hostedZoneConfig() == null ^ this.hostedZoneConfig() == null) {
            return false;
        }
        if (other.hostedZoneConfig() != null && !other.hostedZoneConfig().equals(this.hostedZoneConfig())) {
            return false;
        }
        if (other.delegationSetId() == null ^ this.delegationSetId() == null) {
            return false;
        }
        return other.delegationSetId() == null || other.delegationSetId().equals(this.delegationSetId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.vpc() != null) {
            sb.append("VPC: ").append(this.vpc()).append(",");
        }
        if (this.callerReference() != null) {
            sb.append("CallerReference: ").append(this.callerReference()).append(",");
        }
        if (this.hostedZoneConfig() != null) {
            sb.append("HostedZoneConfig: ").append(this.hostedZoneConfig()).append(",");
        }
        if (this.delegationSetId() != null) {
            sb.append("DelegationSetId: ").append(this.delegationSetId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private VPC vpc;
        private String callerReference;
        private HostedZoneConfig hostedZoneConfig;
        private String delegationSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHostedZoneRequest model) {
            this.setName(model.name);
            this.setVPC(model.vpc);
            this.setCallerReference(model.callerReference);
            this.setHostedZoneConfig(model.hostedZoneConfig);
            this.setDelegationSetId(model.delegationSetId);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final VPC getVPC() {
            return this.vpc;
        }

        @Override
        public final Builder vpc(VPC vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVPC(VPC vpc) {
            this.vpc = vpc;
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final HostedZoneConfig getHostedZoneConfig() {
            return this.hostedZoneConfig;
        }

        @Override
        public final Builder hostedZoneConfig(HostedZoneConfig hostedZoneConfig) {
            this.hostedZoneConfig = hostedZoneConfig;
            return this;
        }

        public final void setHostedZoneConfig(HostedZoneConfig hostedZoneConfig) {
            this.hostedZoneConfig = hostedZoneConfig;
        }

        public final String getDelegationSetId() {
            return this.delegationSetId;
        }

        @Override
        public final Builder delegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
            return this;
        }

        public final void setDelegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
        }

        public CreateHostedZoneRequest build() {
            return new CreateHostedZoneRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateHostedZoneRequest> {
        public Builder name(String var1);

        public Builder vpc(VPC var1);

        public Builder callerReference(String var1);

        public Builder hostedZoneConfig(HostedZoneConfig var1);

        public Builder delegationSetId(String var1);
    }
}

