/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.route53domains.model.ContactDetail;

@SdkInternalApi
public class ContactDetailMarshaller {
    private static final MarshallingInfo<String> FIRSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FirstName").build();
    private static final MarshallingInfo<String> LASTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastName").build();
    private static final MarshallingInfo<String> CONTACTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContactType").build();
    private static final MarshallingInfo<String> ORGANIZATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrganizationName").build();
    private static final MarshallingInfo<String> ADDRESSLINE1_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressLine1").build();
    private static final MarshallingInfo<String> ADDRESSLINE2_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressLine2").build();
    private static final MarshallingInfo<String> CITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("City").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> COUNTRYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CountryCode").build();
    private static final MarshallingInfo<String> ZIPCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ZipCode").build();
    private static final MarshallingInfo<String> PHONENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PhoneNumber").build();
    private static final MarshallingInfo<String> EMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Email").build();
    private static final MarshallingInfo<String> FAX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Fax").build();
    private static final MarshallingInfo<List> EXTRAPARAMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtraParams").build();
    private static final ContactDetailMarshaller instance = new ContactDetailMarshaller();

    public static ContactDetailMarshaller getInstance() {
        return instance;
    }

    public void marshall(ContactDetail contactDetail, ProtocolMarshaller protocolMarshaller) {
        if (contactDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)contactDetail.firstName(), FIRSTNAME_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.lastName(), LASTNAME_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.contactType(), CONTACTTYPE_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.organizationName(), ORGANIZATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.addressLine1(), ADDRESSLINE1_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.addressLine2(), ADDRESSLINE2_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.city(), CITY_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.state(), STATE_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.countryCode(), COUNTRYCODE_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.zipCode(), ZIPCODE_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.phoneNumber(), PHONENUMBER_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.email(), EMAIL_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.fax(), FAX_BINDING);
            protocolMarshaller.marshall(contactDetail.extraParams(), EXTRAPARAMS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

