/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.route53.model.ListTrafficPoliciesRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListTrafficPoliciesRequestMarshaller
implements Marshaller<Request<ListTrafficPoliciesRequest>, ListTrafficPoliciesRequest> {
    public Request<ListTrafficPoliciesRequest> marshall(ListTrafficPoliciesRequest listTrafficPoliciesRequest) {
        if (listTrafficPoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listTrafficPoliciesRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/trafficpolicies";
        request.setResourcePath(uriResourcePath);
        if (listTrafficPoliciesRequest.trafficPolicyIdMarker() != null) {
            request.addParameter("trafficpolicyid", StringUtils.fromString((String)listTrafficPoliciesRequest.trafficPolicyIdMarker()));
        }
        if (listTrafficPoliciesRequest.maxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString((String)listTrafficPoliciesRequest.maxItems()));
        }
        return request;
    }
}

