/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.route53.model.GeoLocationDetails;
import software.amazon.awssdk.services.route53.model.GeoLocationDetailsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListGeoLocationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListGeoLocationsResponse> {
    private final List<GeoLocationDetails> geoLocationDetailsList;
    private final Boolean isTruncated;
    private final String nextContinentCode;
    private final String nextCountryCode;
    private final String nextSubdivisionCode;
    private final String maxItems;

    private ListGeoLocationsResponse(BuilderImpl builder) {
        this.geoLocationDetailsList = builder.geoLocationDetailsList;
        this.isTruncated = builder.isTruncated;
        this.nextContinentCode = builder.nextContinentCode;
        this.nextCountryCode = builder.nextCountryCode;
        this.nextSubdivisionCode = builder.nextSubdivisionCode;
        this.maxItems = builder.maxItems;
    }

    public List<GeoLocationDetails> geoLocationDetailsList() {
        return this.geoLocationDetailsList;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String nextContinentCode() {
        return this.nextContinentCode;
    }

    public String nextCountryCode() {
        return this.nextCountryCode;
    }

    public String nextSubdivisionCode() {
        return this.nextSubdivisionCode;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.geoLocationDetailsList() == null ? 0 : this.geoLocationDetailsList().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.nextContinentCode() == null ? 0 : this.nextContinentCode().hashCode());
        hashCode = 31 * hashCode + (this.nextCountryCode() == null ? 0 : this.nextCountryCode().hashCode());
        hashCode = 31 * hashCode + (this.nextSubdivisionCode() == null ? 0 : this.nextSubdivisionCode().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeoLocationsResponse)) {
            return false;
        }
        ListGeoLocationsResponse other = (ListGeoLocationsResponse)((Object)obj);
        if (other.geoLocationDetailsList() == null ^ this.geoLocationDetailsList() == null) {
            return false;
        }
        if (other.geoLocationDetailsList() != null && !other.geoLocationDetailsList().equals(this.geoLocationDetailsList())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.nextContinentCode() == null ^ this.nextContinentCode() == null) {
            return false;
        }
        if (other.nextContinentCode() != null && !other.nextContinentCode().equals(this.nextContinentCode())) {
            return false;
        }
        if (other.nextCountryCode() == null ^ this.nextCountryCode() == null) {
            return false;
        }
        if (other.nextCountryCode() != null && !other.nextCountryCode().equals(this.nextCountryCode())) {
            return false;
        }
        if (other.nextSubdivisionCode() == null ^ this.nextSubdivisionCode() == null) {
            return false;
        }
        if (other.nextSubdivisionCode() != null && !other.nextSubdivisionCode().equals(this.nextSubdivisionCode())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        return other.maxItems() == null || other.maxItems().equals(this.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.geoLocationDetailsList() != null) {
            sb.append("GeoLocationDetailsList: ").append(this.geoLocationDetailsList()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.nextContinentCode() != null) {
            sb.append("NextContinentCode: ").append(this.nextContinentCode()).append(",");
        }
        if (this.nextCountryCode() != null) {
            sb.append("NextCountryCode: ").append(this.nextCountryCode()).append(",");
        }
        if (this.nextSubdivisionCode() != null) {
            sb.append("NextSubdivisionCode: ").append(this.nextSubdivisionCode()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<GeoLocationDetails> geoLocationDetailsList;
        private Boolean isTruncated;
        private String nextContinentCode;
        private String nextCountryCode;
        private String nextSubdivisionCode;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeoLocationsResponse model) {
            this.setGeoLocationDetailsList(model.geoLocationDetailsList);
            this.setIsTruncated(model.isTruncated);
            this.setNextContinentCode(model.nextContinentCode);
            this.setNextCountryCode(model.nextCountryCode);
            this.setNextSubdivisionCode(model.nextSubdivisionCode);
            this.setMaxItems(model.maxItems);
        }

        public final Collection<GeoLocationDetails> getGeoLocationDetailsList() {
            return this.geoLocationDetailsList;
        }

        @Override
        public final Builder geoLocationDetailsList(Collection<GeoLocationDetails> geoLocationDetailsList) {
            this.geoLocationDetailsList = GeoLocationDetailsListCopier.copy(geoLocationDetailsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoLocationDetailsList(GeoLocationDetails ... geoLocationDetailsList) {
            this.geoLocationDetailsList(Arrays.asList(geoLocationDetailsList));
            return this;
        }

        public final void setGeoLocationDetailsList(Collection<GeoLocationDetails> geoLocationDetailsList) {
            this.geoLocationDetailsList = GeoLocationDetailsListCopier.copy(geoLocationDetailsList);
        }

        @SafeVarargs
        public final void setGeoLocationDetailsList(GeoLocationDetails ... geoLocationDetailsList) {
            this.geoLocationDetailsList(Arrays.asList(geoLocationDetailsList));
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextContinentCode() {
            return this.nextContinentCode;
        }

        @Override
        public final Builder nextContinentCode(String nextContinentCode) {
            this.nextContinentCode = nextContinentCode;
            return this;
        }

        public final void setNextContinentCode(String nextContinentCode) {
            this.nextContinentCode = nextContinentCode;
        }

        public final String getNextCountryCode() {
            return this.nextCountryCode;
        }

        @Override
        public final Builder nextCountryCode(String nextCountryCode) {
            this.nextCountryCode = nextCountryCode;
            return this;
        }

        public final void setNextCountryCode(String nextCountryCode) {
            this.nextCountryCode = nextCountryCode;
        }

        public final String getNextSubdivisionCode() {
            return this.nextSubdivisionCode;
        }

        @Override
        public final Builder nextSubdivisionCode(String nextSubdivisionCode) {
            this.nextSubdivisionCode = nextSubdivisionCode;
            return this;
        }

        public final void setNextSubdivisionCode(String nextSubdivisionCode) {
            this.nextSubdivisionCode = nextSubdivisionCode;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public ListGeoLocationsResponse build() {
            return new ListGeoLocationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListGeoLocationsResponse> {
        public Builder geoLocationDetailsList(Collection<GeoLocationDetails> var1);

        public Builder geoLocationDetailsList(GeoLocationDetails ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder nextContinentCode(String var1);

        public Builder nextCountryCode(String var1);

        public Builder nextSubdivisionCode(String var1);

        public Builder maxItems(String var1);
    }
}

