/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.route53.model.HealthCheckObservation;
import software.amazon.awssdk.services.route53.model.HealthCheckObservationsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetHealthCheckStatusResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetHealthCheckStatusResponse> {
    private final List<HealthCheckObservation> healthCheckObservations;

    private GetHealthCheckStatusResponse(BuilderImpl builder) {
        this.healthCheckObservations = builder.healthCheckObservations;
    }

    public List<HealthCheckObservation> healthCheckObservations() {
        return this.healthCheckObservations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.healthCheckObservations() == null ? 0 : this.healthCheckObservations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHealthCheckStatusResponse)) {
            return false;
        }
        GetHealthCheckStatusResponse other = (GetHealthCheckStatusResponse)((Object)obj);
        if (other.healthCheckObservations() == null ^ this.healthCheckObservations() == null) {
            return false;
        }
        return other.healthCheckObservations() == null || other.healthCheckObservations().equals(this.healthCheckObservations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.healthCheckObservations() != null) {
            sb.append("HealthCheckObservations: ").append(this.healthCheckObservations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<HealthCheckObservation> healthCheckObservations;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHealthCheckStatusResponse model) {
            this.setHealthCheckObservations(model.healthCheckObservations);
        }

        public final Collection<HealthCheckObservation> getHealthCheckObservations() {
            return this.healthCheckObservations;
        }

        @Override
        public final Builder healthCheckObservations(Collection<HealthCheckObservation> healthCheckObservations) {
            this.healthCheckObservations = HealthCheckObservationsCopier.copy(healthCheckObservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthCheckObservations(HealthCheckObservation ... healthCheckObservations) {
            this.healthCheckObservations(Arrays.asList(healthCheckObservations));
            return this;
        }

        public final void setHealthCheckObservations(Collection<HealthCheckObservation> healthCheckObservations) {
            this.healthCheckObservations = HealthCheckObservationsCopier.copy(healthCheckObservations);
        }

        @SafeVarargs
        public final void setHealthCheckObservations(HealthCheckObservation ... healthCheckObservations) {
            this.healthCheckObservations(Arrays.asList(healthCheckObservations));
        }

        public GetHealthCheckStatusResponse build() {
            return new GetHealthCheckStatusResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetHealthCheckStatusResponse> {
        public Builder healthCheckObservations(Collection<HealthCheckObservation> var1);

        public Builder healthCheckObservations(HealthCheckObservation ... var1);
    }
}

