/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.route53.model.Tag;
import software.amazon.awssdk.services.route53.model.TagKeyListCopier;
import software.amazon.awssdk.services.route53.model.TagListCopier;
import software.amazon.awssdk.services.route53.model.TagResourceType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ChangeTagsForResourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ChangeTagsForResourceRequest> {
    private final String resourceType;
    private final String resourceId;
    private final List<Tag> addTags;
    private final List<String> removeTagKeys;

    private ChangeTagsForResourceRequest(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.addTags = builder.addTags;
        this.removeTagKeys = builder.removeTagKeys;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public List<Tag> addTags() {
        return this.addTags;
    }

    public List<String> removeTagKeys() {
        return this.removeTagKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        hashCode = 31 * hashCode + (this.addTags() == null ? 0 : this.addTags().hashCode());
        hashCode = 31 * hashCode + (this.removeTagKeys() == null ? 0 : this.removeTagKeys().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeTagsForResourceRequest)) {
            return false;
        }
        ChangeTagsForResourceRequest other = (ChangeTagsForResourceRequest)((Object)obj);
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.addTags() == null ^ this.addTags() == null) {
            return false;
        }
        if (other.addTags() != null && !other.addTags().equals(this.addTags())) {
            return false;
        }
        if (other.removeTagKeys() == null ^ this.removeTagKeys() == null) {
            return false;
        }
        return other.removeTagKeys() == null || other.removeTagKeys().equals(this.removeTagKeys());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.addTags() != null) {
            sb.append("AddTags: ").append(this.addTags()).append(",");
        }
        if (this.removeTagKeys() != null) {
            sb.append("RemoveTagKeys: ").append(this.removeTagKeys()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String resourceId;
        private List<Tag> addTags;
        private List<String> removeTagKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeTagsForResourceRequest model) {
            this.setResourceType(model.resourceType);
            this.setResourceId(model.resourceId);
            this.setAddTags(model.addTags);
            this.setRemoveTagKeys(model.removeTagKeys);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TagResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final void setResourceType(TagResourceType resourceType) {
            this.resourceType(resourceType.toString());
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<Tag> getAddTags() {
            return this.addTags;
        }

        @Override
        public final Builder addTags(Collection<Tag> addTags) {
            this.addTags = TagListCopier.copy(addTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Tag ... addTags) {
            this.addTags(Arrays.asList(addTags));
            return this;
        }

        public final void setAddTags(Collection<Tag> addTags) {
            this.addTags = TagListCopier.copy(addTags);
        }

        @SafeVarargs
        public final void setAddTags(Tag ... addTags) {
            this.addTags(Arrays.asList(addTags));
        }

        public final Collection<String> getRemoveTagKeys() {
            return this.removeTagKeys;
        }

        @Override
        public final Builder removeTagKeys(Collection<String> removeTagKeys) {
            this.removeTagKeys = TagKeyListCopier.copy(removeTagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeTagKeys(String ... removeTagKeys) {
            this.removeTagKeys(Arrays.asList(removeTagKeys));
            return this;
        }

        public final void setRemoveTagKeys(Collection<String> removeTagKeys) {
            this.removeTagKeys = TagKeyListCopier.copy(removeTagKeys);
        }

        @SafeVarargs
        public final void setRemoveTagKeys(String ... removeTagKeys) {
            this.removeTagKeys(Arrays.asList(removeTagKeys));
        }

        public ChangeTagsForResourceRequest build() {
            return new ChangeTagsForResourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ChangeTagsForResourceRequest> {
        public Builder resourceType(String var1);

        public Builder resourceType(TagResourceType var1);

        public Builder resourceId(String var1);

        public Builder addTags(Collection<Tag> var1);

        public Builder addTags(Tag ... var1);

        public Builder removeTagKeys(Collection<String> var1);

        public Builder removeTagKeys(String ... var1);
    }
}

