/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53;

import java.net.URI;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.Aws4Signer;
import software.amazon.awssdk.auth.Signer;
import software.amazon.awssdk.auth.StaticSignerProvider;
import software.amazon.awssdk.client.builder.ClientBuilder;
import software.amazon.awssdk.client.builder.DefaultClientBuilder;
import software.amazon.awssdk.config.defaults.ClientConfigurationDefaults;
import software.amazon.awssdk.config.defaults.ServiceBuilderConfigurationDefaults;
import software.amazon.awssdk.runtime.auth.SignerProvider;
import software.amazon.awssdk.services.route53.Route53BaseClientBuilder;

@SdkInternalApi
abstract class DefaultRoute53BaseClientBuilder<B extends Route53BaseClientBuilder<B, C>, C>
extends DefaultClientBuilder<B, C>
implements ClientBuilder<B, C> {
    DefaultRoute53BaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "route53";
    }

    protected final ClientConfigurationDefaults serviceDefaults() {
        return ServiceBuilderConfigurationDefaults.builder().defaultSignerProvider(this::defaultSignerProvider).addRequestHandlerPath("/software/amazon/awssdk/services/route53/request.handler2s").defaultEndpoint(this::defaultEndpoint).build();
    }

    private SignerProvider defaultSignerProvider() {
        Aws4Signer signer = new Aws4Signer();
        signer.setServiceName("route53");
        signer.setRegionName(this.signingRegion().value());
        return new StaticSignerProvider((Signer)signer);
    }

    private URI defaultEndpoint() {
        return null;
    }
}

