/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.route53.model.AlarmIdentifier;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.HealthCheckConfig;
import software.amazon.awssdk.utils.StringInputStream;

public class CreateHealthCheckRequestMarshaller
implements Marshaller<Request<CreateHealthCheckRequest>, CreateHealthCheckRequest> {
    public Request<CreateHealthCheckRequest> marshall(CreateHealthCheckRequest createHealthCheckRequest) {
        if (createHealthCheckRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createHealthCheckRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/healthcheck";
        request.setResourcePath(uriResourcePath);
        try {
            HealthCheckConfig healthCheckConfig;
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("CreateHealthCheckRequest");
            if (createHealthCheckRequest.callerReference() != null) {
                xmlWriter.startElement("CallerReference").value(createHealthCheckRequest.callerReference()).endElement();
            }
            if ((healthCheckConfig = createHealthCheckRequest.healthCheckConfig()) != null) {
                AlarmIdentifier alarmIdentifier;
                List<String> healthCheckConfigRegionsList;
                List<String> healthCheckConfigChildHealthChecksList;
                xmlWriter.startElement("HealthCheckConfig");
                if (healthCheckConfig.ipAddress() != null) {
                    xmlWriter.startElement("IPAddress").value(healthCheckConfig.ipAddress()).endElement();
                }
                if (healthCheckConfig.port() != null) {
                    xmlWriter.startElement("Port").value((Object)healthCheckConfig.port()).endElement();
                }
                if (healthCheckConfig.typeAsString() != null) {
                    xmlWriter.startElement("Type").value(healthCheckConfig.typeAsString()).endElement();
                }
                if (healthCheckConfig.resourcePath() != null) {
                    xmlWriter.startElement("ResourcePath").value(healthCheckConfig.resourcePath()).endElement();
                }
                if (healthCheckConfig.fullyQualifiedDomainName() != null) {
                    xmlWriter.startElement("FullyQualifiedDomainName").value(healthCheckConfig.fullyQualifiedDomainName()).endElement();
                }
                if (healthCheckConfig.searchString() != null) {
                    xmlWriter.startElement("SearchString").value(healthCheckConfig.searchString()).endElement();
                }
                if (healthCheckConfig.requestInterval() != null) {
                    xmlWriter.startElement("RequestInterval").value((Object)healthCheckConfig.requestInterval()).endElement();
                }
                if (healthCheckConfig.failureThreshold() != null) {
                    xmlWriter.startElement("FailureThreshold").value((Object)healthCheckConfig.failureThreshold()).endElement();
                }
                if (healthCheckConfig.measureLatency() != null) {
                    xmlWriter.startElement("MeasureLatency").value((Object)healthCheckConfig.measureLatency()).endElement();
                }
                if (healthCheckConfig.inverted() != null) {
                    xmlWriter.startElement("Inverted").value((Object)healthCheckConfig.inverted()).endElement();
                }
                if (healthCheckConfig.healthThreshold() != null) {
                    xmlWriter.startElement("HealthThreshold").value((Object)healthCheckConfig.healthThreshold()).endElement();
                }
                if (!(healthCheckConfigChildHealthChecksList = healthCheckConfig.childHealthChecks()).isEmpty() || !(healthCheckConfigChildHealthChecksList instanceof SdkAutoConstructList)) {
                    xmlWriter.startElement("ChildHealthChecks");
                    for (String string : healthCheckConfigChildHealthChecksList) {
                        xmlWriter.startElement("ChildHealthCheck");
                        xmlWriter.value(string);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (healthCheckConfig.enableSNI() != null) {
                    xmlWriter.startElement("EnableSNI").value((Object)healthCheckConfig.enableSNI()).endElement();
                }
                if (!(healthCheckConfigRegionsList = healthCheckConfig.regionsAsStrings()).isEmpty() || !(healthCheckConfigRegionsList instanceof SdkAutoConstructList)) {
                    xmlWriter.startElement("Regions");
                    for (String healthCheckConfigRegionsListValue : healthCheckConfigRegionsList) {
                        xmlWriter.startElement("Region");
                        xmlWriter.value(healthCheckConfigRegionsListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((alarmIdentifier = healthCheckConfig.alarmIdentifier()) != null) {
                    xmlWriter.startElement("AlarmIdentifier");
                    if (alarmIdentifier.regionAsString() != null) {
                        xmlWriter.startElement("Region").value(alarmIdentifier.regionAsString()).endElement();
                    }
                    if (alarmIdentifier.name() != null) {
                        xmlWriter.startElement("Name").value(alarmIdentifier.name()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if (healthCheckConfig.insufficientDataHealthStatusAsString() != null) {
                    xmlWriter.startElement("InsufficientDataHealthStatus").value(healthCheckConfig.insufficientDataHealthStatusAsString()).endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

