/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.transform.HostedZoneConfigUnmarshaller;
import software.amazon.awssdk.services.route53.transform.LinkedServiceUnmarshaller;

public class HostedZoneUnmarshaller
implements Unmarshaller<HostedZone, StaxUnmarshallerContext> {
    private static final HostedZoneUnmarshaller INSTANCE = new HostedZoneUnmarshaller();

    public HostedZone unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        HostedZone.Builder hostedZone = HostedZone.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    hostedZone.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Name", targetDepth)) {
                    hostedZone.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CallerReference", targetDepth)) {
                    hostedZone.callerReference(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Config", targetDepth)) {
                    hostedZone.config(HostedZoneConfigUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceRecordSetCount", targetDepth)) {
                    hostedZone.resourceRecordSetCount(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("LinkedService", targetDepth)) continue;
                hostedZone.linkedService(LinkedServiceUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (HostedZone)hostedZone.build();
    }

    public static HostedZoneUnmarshaller getInstance() {
        return INSTANCE;
    }
}

