/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.ErrorMessagesCopier;
import software.amazon.awssdk.services.route53.model.Route53Exception;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvalidChangeBatchException
extends Route53Exception
implements ToCopyableBuilder<Builder, InvalidChangeBatchException> {
    private final List<String> messages;

    private InvalidChangeBatchException(BuilderImpl builder) {
        super(builder);
        this.messages = builder.messages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public List<String> messages() {
        return this.messages;
    }

    static final class BuilderImpl
    extends Route53Exception.BuilderImpl
    implements Builder {
        private List<String> messages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidChangeBatchException model) {
            super(model);
            this.messages(model.messages);
        }

        public final Collection<String> getMessages() {
            return this.messages;
        }

        @Override
        public final Builder messages(Collection<String> messages) {
            this.messages = ErrorMessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(String ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        public final void setMessages(Collection<String> messages) {
            this.messages = ErrorMessagesCopier.copy(messages);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public InvalidChangeBatchException build() {
            return new InvalidChangeBatchException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InvalidChangeBatchException>,
    Route53Exception.Builder {
        public Builder messages(Collection<String> var1);

        public Builder messages(String ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

