/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.route53.model.HostedZoneLimitType;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetHostedZoneLimitRequest
extends Route53Request
implements ToCopyableBuilder<Builder, GetHostedZoneLimitRequest> {
    private final String type;
    private final String hostedZoneId;

    private GetHostedZoneLimitRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.hostedZoneId = builder.hostedZoneId;
    }

    public HostedZoneLimitType type() {
        return HostedZoneLimitType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostedZoneLimitRequest)) {
            return false;
        }
        GetHostedZoneLimitRequest other = (GetHostedZoneLimitRequest)((Object)obj);
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId());
    }

    public String toString() {
        return ToString.builder((String)"GetHostedZoneLimitRequest").add("Type", (Object)this.typeAsString()).add("HostedZoneId", (Object)this.hostedZoneId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String type;
        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostedZoneLimitRequest model) {
            super(model);
            this.type(model.type);
            this.hostedZoneId(model.hostedZoneId);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HostedZoneLimitType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetHostedZoneLimitRequest build() {
            return new GetHostedZoneLimitRequest(this);
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    CopyableBuilder<Builder, GetHostedZoneLimitRequest> {
        public Builder type(String var1);

        public Builder type(HostedZoneLimitType var1);

        public Builder hostedZoneId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

