/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.services.route53.model.VPC;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcAssociationAuthorizationRequest
extends Route53Request
implements ToCopyableBuilder<Builder, CreateVpcAssociationAuthorizationRequest> {
    private final String hostedZoneId;
    private final VPC vpc;

    private CreateVpcAssociationAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.vpc = builder.vpc;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public VPC vpc() {
        return this.vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcAssociationAuthorizationRequest)) {
            return false;
        }
        CreateVpcAssociationAuthorizationRequest other = (CreateVpcAssociationAuthorizationRequest)((Object)obj);
        return Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.vpc(), other.vpc());
    }

    public String toString() {
        return ToString.builder((String)"CreateVpcAssociationAuthorizationRequest").add("HostedZoneId", (Object)this.hostedZoneId()).add("VPC", (Object)this.vpc()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "VPC": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private VPC vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcAssociationAuthorizationRequest model) {
            super(model);
            this.hostedZoneId(model.hostedZoneId);
            this.vpc(model.vpc);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final VPC.Builder getVPC() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(VPC vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVPC(VPC.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcAssociationAuthorizationRequest build() {
            return new CreateVpcAssociationAuthorizationRequest(this);
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    CopyableBuilder<Builder, CreateVpcAssociationAuthorizationRequest> {
        public Builder hostedZoneId(String var1);

        public Builder vpc(VPC var1);

        default public Builder vpc(Consumer<VPC.Builder> vpc) {
            return this.vpc((VPC)((VPC.Builder)VPC.builder().applyMutation(vpc)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

