/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CrlDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CrlDetail> {
    private static final SdkField<String> CRL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("crlId").getter(CrlDetail.getter(CrlDetail::crlId)).setter(CrlDetail.setter(Builder::crlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crlId").build()}).build();
    private static final SdkField<String> CRL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("crlArn").getter(CrlDetail.getter(CrlDetail::crlArn)).setter(CrlDetail.setter(Builder::crlArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crlArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CrlDetail.getter(CrlDetail::name)).setter(CrlDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(CrlDetail.getter(CrlDetail::enabled)).setter(CrlDetail.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<SdkBytes> CRL_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("crlData").getter(CrlDetail.getter(CrlDetail::crlData)).setter(CrlDetail.setter(Builder::crlData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crlData").build()}).build();
    private static final SdkField<String> TRUST_ANCHOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trustAnchorArn").getter(CrlDetail.getter(CrlDetail::trustAnchorArn)).setter(CrlDetail.setter(Builder::trustAnchorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustAnchorArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CrlDetail.getter(CrlDetail::createdAt)).setter(CrlDetail.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(CrlDetail.getter(CrlDetail::updatedAt)).setter(CrlDetail.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRL_ID_FIELD, CRL_ARN_FIELD, NAME_FIELD, ENABLED_FIELD, CRL_DATA_FIELD, TRUST_ANCHOR_ARN_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CrlDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String crlId;
    private final String crlArn;
    private final String name;
    private final Boolean enabled;
    private final SdkBytes crlData;
    private final String trustAnchorArn;
    private final Instant createdAt;
    private final Instant updatedAt;

    private CrlDetail(BuilderImpl builder) {
        this.crlId = builder.crlId;
        this.crlArn = builder.crlArn;
        this.name = builder.name;
        this.enabled = builder.enabled;
        this.crlData = builder.crlData;
        this.trustAnchorArn = builder.trustAnchorArn;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String crlId() {
        return this.crlId;
    }

    public final String crlArn() {
        return this.crlArn;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final SdkBytes crlData() {
        return this.crlData;
    }

    public final String trustAnchorArn() {
        return this.trustAnchorArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.crlArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.crlData());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustAnchorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrlDetail)) {
            return false;
        }
        CrlDetail other = (CrlDetail)obj;
        return Objects.equals(this.crlId(), other.crlId()) && Objects.equals(this.crlArn(), other.crlArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.crlData(), other.crlData()) && Objects.equals(this.trustAnchorArn(), other.trustAnchorArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"CrlDetail").add("CrlId", (Object)this.crlId()).add("CrlArn", (Object)this.crlArn()).add("Name", (Object)this.name()).add("Enabled", (Object)this.enabled()).add("CrlData", (Object)this.crlData()).add("TrustAnchorArn", (Object)this.trustAnchorArn()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "crlId": {
                return Optional.ofNullable(clazz.cast(this.crlId()));
            }
            case "crlArn": {
                return Optional.ofNullable(clazz.cast(this.crlArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "crlData": {
                return Optional.ofNullable(clazz.cast(this.crlData()));
            }
            case "trustAnchorArn": {
                return Optional.ofNullable(clazz.cast(this.trustAnchorArn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("crlId", CRL_ID_FIELD);
        map.put("crlArn", CRL_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("crlData", CRL_DATA_FIELD);
        map.put("trustAnchorArn", TRUST_ANCHOR_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CrlDetail, T> g) {
        return obj -> g.apply((CrlDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String crlId;
        private String crlArn;
        private String name;
        private Boolean enabled;
        private SdkBytes crlData;
        private String trustAnchorArn;
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CrlDetail model) {
            this.crlId(model.crlId);
            this.crlArn(model.crlArn);
            this.name(model.name);
            this.enabled(model.enabled);
            this.crlData(model.crlData);
            this.trustAnchorArn(model.trustAnchorArn);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getCrlId() {
            return this.crlId;
        }

        public final void setCrlId(String crlId) {
            this.crlId = crlId;
        }

        @Override
        public final Builder crlId(String crlId) {
            this.crlId = crlId;
            return this;
        }

        public final String getCrlArn() {
            return this.crlArn;
        }

        public final void setCrlArn(String crlArn) {
            this.crlArn = crlArn;
        }

        @Override
        public final Builder crlArn(String crlArn) {
            this.crlArn = crlArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final ByteBuffer getCrlData() {
            return this.crlData == null ? null : this.crlData.asByteBuffer();
        }

        public final void setCrlData(ByteBuffer crlData) {
            this.crlData(crlData == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)crlData));
        }

        @Override
        public final Builder crlData(SdkBytes crlData) {
            this.crlData = crlData;
            return this;
        }

        public final String getTrustAnchorArn() {
            return this.trustAnchorArn;
        }

        public final void setTrustAnchorArn(String trustAnchorArn) {
            this.trustAnchorArn = trustAnchorArn;
        }

        @Override
        public final Builder trustAnchorArn(String trustAnchorArn) {
            this.trustAnchorArn = trustAnchorArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public CrlDetail build() {
            return new CrlDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CrlDetail> {
        public Builder crlId(String var1);

        public Builder crlArn(String var1);

        public Builder name(String var1);

        public Builder enabled(Boolean var1);

        public Builder crlData(SdkBytes var1);

        public Builder trustAnchorArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

