/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rolesanywhere.model.NotificationChannel;
import software.amazon.awssdk.services.rolesanywhere.model.NotificationEvent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationSetting> {
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channel").getter(NotificationSetting.getter(NotificationSetting::channelAsString)).setter(NotificationSetting.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(NotificationSetting.getter(NotificationSetting::enabled)).setter(NotificationSetting.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<String> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("event").getter(NotificationSetting.getter(NotificationSetting::eventAsString)).setter(NotificationSetting.setter(Builder::event)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()}).build();
    private static final SdkField<Integer> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("threshold").getter(NotificationSetting.getter(NotificationSetting::threshold)).setter(NotificationSetting.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD, ENABLED_FIELD, EVENT_FIELD, THRESHOLD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NotificationSetting.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String channel;
    private final Boolean enabled;
    private final String event;
    private final Integer threshold;

    private NotificationSetting(BuilderImpl builder) {
        this.channel = builder.channel;
        this.enabled = builder.enabled;
        this.event = builder.event;
        this.threshold = builder.threshold;
    }

    public final NotificationChannel channel() {
        return NotificationChannel.fromValue(this.channel);
    }

    public final String channelAsString() {
        return this.channel;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final NotificationEvent event() {
        return NotificationEvent.fromValue(this.event);
    }

    public final String eventAsString() {
        return this.event;
    }

    public final Integer threshold() {
        return this.threshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationSetting)) {
            return false;
        }
        NotificationSetting other = (NotificationSetting)obj;
        return Objects.equals(this.channelAsString(), other.channelAsString()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.eventAsString(), other.eventAsString()) && Objects.equals(this.threshold(), other.threshold());
    }

    public final String toString() {
        return ToString.builder((String)"NotificationSetting").add("Channel", (Object)this.channelAsString()).add("Enabled", (Object)this.enabled()).add("Event", (Object)this.eventAsString()).add("Threshold", (Object)this.threshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channel": {
                return Optional.ofNullable(clazz.cast(this.channelAsString()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "event": {
                return Optional.ofNullable(clazz.cast(this.eventAsString()));
            }
            case "threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channel", CHANNEL_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("event", EVENT_FIELD);
        map.put("threshold", THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationSetting, T> g) {
        return obj -> g.apply((NotificationSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channel;
        private Boolean enabled;
        private String event;
        private Integer threshold;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationSetting model) {
            this.channel(model.channel);
            this.enabled(model.enabled);
            this.event(model.event);
            this.threshold(model.threshold);
        }

        public final String getChannel() {
            return this.channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(NotificationChannel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getEvent() {
            return this.event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(NotificationEvent event) {
            this.event(event == null ? null : event.toString());
            return this;
        }

        public final Integer getThreshold() {
            return this.threshold;
        }

        public final void setThreshold(Integer threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Integer threshold) {
            this.threshold = threshold;
            return this;
        }

        public NotificationSetting build() {
            return new NotificationSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationSetting> {
        public Builder channel(String var1);

        public Builder channel(NotificationChannel var1);

        public Builder enabled(Boolean var1);

        public Builder event(String var1);

        public Builder event(NotificationEvent var1);

        public Builder threshold(Integer var1);
    }
}

