/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.rolesanywhere.RolesAnywhereClient;
import software.amazon.awssdk.services.rolesanywhere.model.AccessDeniedException;
import software.amazon.awssdk.services.rolesanywhere.model.CreateProfileRequest;
import software.amazon.awssdk.services.rolesanywhere.model.CreateProfileResponse;
import software.amazon.awssdk.services.rolesanywhere.model.CreateTrustAnchorRequest;
import software.amazon.awssdk.services.rolesanywhere.model.CreateTrustAnchorResponse;
import software.amazon.awssdk.services.rolesanywhere.model.DeleteCrlRequest;
import software.amazon.awssdk.services.rolesanywhere.model.DeleteCrlResponse;
import software.amazon.awssdk.services.rolesanywhere.model.DeleteProfileRequest;
import software.amazon.awssdk.services.rolesanywhere.model.DeleteProfileResponse;
import software.amazon.awssdk.services.rolesanywhere.model.DeleteTrustAnchorRequest;
import software.amazon.awssdk.services.rolesanywhere.model.DeleteTrustAnchorResponse;
import software.amazon.awssdk.services.rolesanywhere.model.DisableCrlRequest;
import software.amazon.awssdk.services.rolesanywhere.model.DisableCrlResponse;
import software.amazon.awssdk.services.rolesanywhere.model.DisableProfileRequest;
import software.amazon.awssdk.services.rolesanywhere.model.DisableProfileResponse;
import software.amazon.awssdk.services.rolesanywhere.model.DisableTrustAnchorRequest;
import software.amazon.awssdk.services.rolesanywhere.model.DisableTrustAnchorResponse;
import software.amazon.awssdk.services.rolesanywhere.model.EnableCrlRequest;
import software.amazon.awssdk.services.rolesanywhere.model.EnableCrlResponse;
import software.amazon.awssdk.services.rolesanywhere.model.EnableProfileRequest;
import software.amazon.awssdk.services.rolesanywhere.model.EnableProfileResponse;
import software.amazon.awssdk.services.rolesanywhere.model.EnableTrustAnchorRequest;
import software.amazon.awssdk.services.rolesanywhere.model.EnableTrustAnchorResponse;
import software.amazon.awssdk.services.rolesanywhere.model.GetCrlRequest;
import software.amazon.awssdk.services.rolesanywhere.model.GetCrlResponse;
import software.amazon.awssdk.services.rolesanywhere.model.GetProfileRequest;
import software.amazon.awssdk.services.rolesanywhere.model.GetProfileResponse;
import software.amazon.awssdk.services.rolesanywhere.model.GetSubjectRequest;
import software.amazon.awssdk.services.rolesanywhere.model.GetSubjectResponse;
import software.amazon.awssdk.services.rolesanywhere.model.GetTrustAnchorRequest;
import software.amazon.awssdk.services.rolesanywhere.model.GetTrustAnchorResponse;
import software.amazon.awssdk.services.rolesanywhere.model.ImportCrlRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ImportCrlResponse;
import software.amazon.awssdk.services.rolesanywhere.model.ListCrlsRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ListCrlsResponse;
import software.amazon.awssdk.services.rolesanywhere.model.ListProfilesRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ListProfilesResponse;
import software.amazon.awssdk.services.rolesanywhere.model.ListSubjectsRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ListSubjectsResponse;
import software.amazon.awssdk.services.rolesanywhere.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.rolesanywhere.model.ListTrustAnchorsRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ListTrustAnchorsResponse;
import software.amazon.awssdk.services.rolesanywhere.model.ResourceNotFoundException;
import software.amazon.awssdk.services.rolesanywhere.model.RolesAnywhereException;
import software.amazon.awssdk.services.rolesanywhere.model.RolesAnywhereRequest;
import software.amazon.awssdk.services.rolesanywhere.model.TagResourceRequest;
import software.amazon.awssdk.services.rolesanywhere.model.TagResourceResponse;
import software.amazon.awssdk.services.rolesanywhere.model.TooManyTagsException;
import software.amazon.awssdk.services.rolesanywhere.model.UntagResourceRequest;
import software.amazon.awssdk.services.rolesanywhere.model.UntagResourceResponse;
import software.amazon.awssdk.services.rolesanywhere.model.UpdateCrlRequest;
import software.amazon.awssdk.services.rolesanywhere.model.UpdateCrlResponse;
import software.amazon.awssdk.services.rolesanywhere.model.UpdateProfileRequest;
import software.amazon.awssdk.services.rolesanywhere.model.UpdateProfileResponse;
import software.amazon.awssdk.services.rolesanywhere.model.UpdateTrustAnchorRequest;
import software.amazon.awssdk.services.rolesanywhere.model.UpdateTrustAnchorResponse;
import software.amazon.awssdk.services.rolesanywhere.model.ValidationException;
import software.amazon.awssdk.services.rolesanywhere.paginators.ListCrlsIterable;
import software.amazon.awssdk.services.rolesanywhere.paginators.ListProfilesIterable;
import software.amazon.awssdk.services.rolesanywhere.paginators.ListSubjectsIterable;
import software.amazon.awssdk.services.rolesanywhere.paginators.ListTrustAnchorsIterable;
import software.amazon.awssdk.services.rolesanywhere.transform.CreateProfileRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.CreateTrustAnchorRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.DeleteCrlRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.DeleteProfileRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.DeleteTrustAnchorRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.DisableCrlRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.DisableProfileRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.DisableTrustAnchorRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.EnableCrlRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.EnableProfileRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.EnableTrustAnchorRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.GetCrlRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.GetProfileRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.GetSubjectRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.GetTrustAnchorRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.ImportCrlRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.ListCrlsRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.ListProfilesRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.ListSubjectsRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.ListTrustAnchorsRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.UpdateCrlRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.UpdateProfileRequestMarshaller;
import software.amazon.awssdk.services.rolesanywhere.transform.UpdateTrustAnchorRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultRolesAnywhereClient
implements RolesAnywhereClient {
    private static final Logger log = Logger.loggerFor(DefaultRolesAnywhereClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRolesAnywhereClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "rolesanywhere";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateProfileResponse createProfile(CreateProfileRequest createProfileRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, createProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateProfile");
            CreateProfileResponse createProfileResponse = (CreateProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$createProfile$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTrustAnchorResponse createTrustAnchor(CreateTrustAnchorRequest createTrustAnchorRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTrustAnchorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, createTrustAnchorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTrustAnchor");
            CreateTrustAnchorResponse createTrustAnchorResponse = (CreateTrustAnchorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrustAnchor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTrustAnchorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTrustAnchorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTrustAnchorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$createTrustAnchor$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCrlResponse deleteCrl(DeleteCrlRequest deleteCrlRequest) throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCrlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, deleteCrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCrl");
            DeleteCrlResponse deleteCrlResponse = (DeleteCrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCrl").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCrlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCrlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$deleteCrl$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteProfileResponse deleteProfile(DeleteProfileRequest deleteProfileRequest) throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, deleteProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteProfile");
            DeleteProfileResponse deleteProfileResponse = (DeleteProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$deleteProfile$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTrustAnchorResponse deleteTrustAnchor(DeleteTrustAnchorRequest deleteTrustAnchorRequest) throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTrustAnchorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, deleteTrustAnchorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTrustAnchor");
            DeleteTrustAnchorResponse deleteTrustAnchorResponse = (DeleteTrustAnchorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrustAnchor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTrustAnchorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTrustAnchorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTrustAnchorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$deleteTrustAnchor$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableCrlResponse disableCrl(DisableCrlRequest disableCrlRequest) throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableCrlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, disableCrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableCrl");
            DisableCrlResponse disableCrlResponse = (DisableCrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableCrl").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableCrlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableCrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableCrlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$disableCrl$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableProfileResponse disableProfile(DisableProfileRequest disableProfileRequest) throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, disableProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableProfile");
            DisableProfileResponse disableProfileResponse = (DisableProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$disableProfile$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableTrustAnchorResponse disableTrustAnchor(DisableTrustAnchorRequest disableTrustAnchorRequest) throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableTrustAnchorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, disableTrustAnchorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableTrustAnchor");
            DisableTrustAnchorResponse disableTrustAnchorResponse = (DisableTrustAnchorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableTrustAnchor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableTrustAnchorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableTrustAnchorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableTrustAnchorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$disableTrustAnchor$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableCrlResponse enableCrl(EnableCrlRequest enableCrlRequest) throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableCrlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, enableCrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableCrl");
            EnableCrlResponse enableCrlResponse = (EnableCrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableCrl").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableCrlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableCrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableCrlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$enableCrl$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableProfileResponse enableProfile(EnableProfileRequest enableProfileRequest) throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, enableProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableProfile");
            EnableProfileResponse enableProfileResponse = (EnableProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$enableProfile$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableTrustAnchorResponse enableTrustAnchor(EnableTrustAnchorRequest enableTrustAnchorRequest) throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableTrustAnchorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, enableTrustAnchorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableTrustAnchor");
            EnableTrustAnchorResponse enableTrustAnchorResponse = (EnableTrustAnchorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableTrustAnchor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableTrustAnchorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableTrustAnchorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableTrustAnchorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$enableTrustAnchor$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCrlResponse getCrl(GetCrlRequest getCrlRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCrlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, getCrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCrl");
            GetCrlResponse getCrlResponse = (GetCrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCrl").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCrlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCrlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$getCrl$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetProfileResponse getProfile(GetProfileRequest getProfileRequest) throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, getProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetProfile");
            GetProfileResponse getProfileResponse = (GetProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$getProfile$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSubjectResponse getSubject(GetSubjectRequest getSubjectRequest) throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSubjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, getSubjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSubject");
            GetSubjectResponse getSubjectResponse = (GetSubjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSubject").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSubjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSubjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSubjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$getSubject$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTrustAnchorResponse getTrustAnchor(GetTrustAnchorRequest getTrustAnchorRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTrustAnchorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, getTrustAnchorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTrustAnchor");
            GetTrustAnchorResponse getTrustAnchorResponse = (GetTrustAnchorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrustAnchor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTrustAnchorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTrustAnchorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTrustAnchorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$getTrustAnchor$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportCrlResponse importCrl(ImportCrlRequest importCrlRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportCrlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, importCrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportCrl");
            ImportCrlResponse importCrlResponse = (ImportCrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportCrl").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importCrlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportCrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importCrlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$importCrl$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCrlsResponse listCrls(ListCrlsRequest listCrlsRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCrlsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, listCrlsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCrls");
            ListCrlsResponse listCrlsResponse = (ListCrlsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCrls").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCrlsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCrlsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCrlsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$listCrls$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCrlsIterable listCrlsPaginator(ListCrlsRequest listCrlsRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return new ListCrlsIterable(this, this.applyPaginatorUserAgent(listCrlsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListProfilesResponse listProfiles(ListProfilesRequest listProfilesRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProfilesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, listProfilesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListProfiles");
            ListProfilesResponse listProfilesResponse = (ListProfilesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProfiles").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listProfilesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListProfilesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listProfilesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$listProfiles$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListProfilesIterable listProfilesPaginator(ListProfilesRequest listProfilesRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return new ListProfilesIterable(this, this.applyPaginatorUserAgent(listProfilesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSubjectsResponse listSubjects(ListSubjectsRequest listSubjectsRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSubjectsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, listSubjectsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSubjects");
            ListSubjectsResponse listSubjectsResponse = (ListSubjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSubjects").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSubjectsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSubjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSubjectsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$listSubjects$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSubjectsIterable listSubjectsPaginator(ListSubjectsRequest listSubjectsRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return new ListSubjectsIterable(this, this.applyPaginatorUserAgent(listSubjectsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$listTagsForResource$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTrustAnchorsResponse listTrustAnchors(ListTrustAnchorsRequest listTrustAnchorsRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTrustAnchorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, listTrustAnchorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTrustAnchors");
            ListTrustAnchorsResponse listTrustAnchorsResponse = (ListTrustAnchorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrustAnchors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTrustAnchorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTrustAnchorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTrustAnchorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$listTrustAnchors$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTrustAnchorsIterable listTrustAnchorsPaginator(ListTrustAnchorsRequest listTrustAnchorsRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        return new ListTrustAnchorsIterable(this, this.applyPaginatorUserAgent(listTrustAnchorsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, TooManyTagsException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$tagResource$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$untagResource$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCrlResponse updateCrl(UpdateCrlRequest updateCrlRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCrlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, updateCrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCrl");
            UpdateCrlResponse updateCrlResponse = (UpdateCrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCrl").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCrlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCrlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$updateCrl$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateProfileResponse updateProfile(UpdateProfileRequest updateProfileRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, updateProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateProfile");
            UpdateProfileResponse updateProfileResponse = (UpdateProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$updateProfile$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTrustAnchorResponse updateTrustAnchor(UpdateTrustAnchorRequest updateTrustAnchorRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, RolesAnywhereException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTrustAnchorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRolesAnywhereClient.resolveMetricPublishers(this.clientConfiguration, updateTrustAnchorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RolesAnywhere");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTrustAnchor");
            UpdateTrustAnchorResponse updateTrustAnchorResponse = (UpdateTrustAnchorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTrustAnchor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTrustAnchorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTrustAnchorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTrustAnchorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRolesAnywhereClient.lambda$updateTrustAnchor$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(RolesAnywhereException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends RolesAnywhereRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.285").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RolesAnywhereRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateTrustAnchor$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateProfile$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCrl$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTrustAnchors$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSubjects$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listProfiles$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCrls$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importCrl$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTrustAnchor$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSubject$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getProfile$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCrl$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableTrustAnchor$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableProfile$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableCrl$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableTrustAnchor$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableProfile$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableCrl$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTrustAnchor$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteProfile$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCrl$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTrustAnchor$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createProfile$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

