/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerClient;
import software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse;

public class ListDeploymentJobsIterable
implements SdkIterable<ListDeploymentJobsResponse> {
    private final RoboMakerClient client;
    private final ListDeploymentJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeploymentJobsIterable(RoboMakerClient client, ListDeploymentJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDeploymentJobsResponseFetcher();
    }

    public Iterator<ListDeploymentJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDeploymentJobsResponseFetcher
    implements SyncPageFetcher<ListDeploymentJobsResponse> {
        private ListDeploymentJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDeploymentJobsResponse nextPage(ListDeploymentJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentJobsIterable.this.client.listDeploymentJobs(ListDeploymentJobsIterable.this.firstRequest);
            }
            return ListDeploymentJobsIterable.this.client.listDeploymentJobs((ListDeploymentJobsRequest)((Object)ListDeploymentJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

