/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.DeploymentJob;
import software.amazon.awssdk.services.robomaker.model.DeploymentJobsCopier;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeploymentJobsResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, ListDeploymentJobsResponse> {
    private static final SdkField<List<DeploymentJob>> DEPLOYMENT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDeploymentJobsResponse.getter(ListDeploymentJobsResponse::deploymentJobs)).setter(ListDeploymentJobsResponse.setter(Builder::deploymentJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeploymentJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDeploymentJobsResponse.getter(ListDeploymentJobsResponse::nextToken)).setter(ListDeploymentJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DeploymentJob> deploymentJobs;
    private final String nextToken;

    private ListDeploymentJobsResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentJobs = builder.deploymentJobs;
        this.nextToken = builder.nextToken;
    }

    public List<DeploymentJob> deploymentJobs() {
        return this.deploymentJobs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentJobsResponse)) {
            return false;
        }
        ListDeploymentJobsResponse other = (ListDeploymentJobsResponse)((Object)obj);
        return Objects.equals(this.deploymentJobs(), other.deploymentJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDeploymentJobsResponse").add("DeploymentJobs", this.deploymentJobs()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentJobs": {
                return Optional.ofNullable(clazz.cast(this.deploymentJobs()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeploymentJobsResponse, T> g) {
        return obj -> g.apply((ListDeploymentJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private List<DeploymentJob> deploymentJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentJobsResponse model) {
            super(model);
            this.deploymentJobs(model.deploymentJobs);
            this.nextToken(model.nextToken);
        }

        public final Collection<DeploymentJob.Builder> getDeploymentJobs() {
            return this.deploymentJobs != null ? (Collection)this.deploymentJobs.stream().map(DeploymentJob::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deploymentJobs(Collection<DeploymentJob> deploymentJobs) {
            this.deploymentJobs = DeploymentJobsCopier.copy(deploymentJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentJobs(DeploymentJob ... deploymentJobs) {
            this.deploymentJobs(Arrays.asList(deploymentJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentJobs(Consumer<DeploymentJob.Builder> ... deploymentJobs) {
            this.deploymentJobs(Stream.of(deploymentJobs).map(c -> (DeploymentJob)((DeploymentJob.Builder)DeploymentJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeploymentJobs(Collection<DeploymentJob.BuilderImpl> deploymentJobs) {
            this.deploymentJobs = DeploymentJobsCopier.copyFromBuilder(deploymentJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeploymentJobsResponse build() {
            return new ListDeploymentJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeploymentJobsResponse> {
        public Builder deploymentJobs(Collection<DeploymentJob> var1);

        public Builder deploymentJobs(DeploymentJob ... var1);

        public Builder deploymentJobs(Consumer<DeploymentJob.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

