/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProgressDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProgressDetail> {
    private static final SdkField<String> CURRENT_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProgressDetail.getter(ProgressDetail::currentProgress)).setter(ProgressDetail.setter(Builder::currentProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentProgress").build()}).build();
    private static final SdkField<String> TARGET_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProgressDetail.getter(ProgressDetail::targetResource)).setter(ProgressDetail.setter(Builder::targetResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_PROGRESS_FIELD, TARGET_RESOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String currentProgress;
    private final String targetResource;

    private ProgressDetail(BuilderImpl builder) {
        this.currentProgress = builder.currentProgress;
        this.targetResource = builder.targetResource;
    }

    public String currentProgress() {
        return this.currentProgress;
    }

    public String targetResource() {
        return this.targetResource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResource());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProgressDetail)) {
            return false;
        }
        ProgressDetail other = (ProgressDetail)obj;
        return Objects.equals(this.currentProgress(), other.currentProgress()) && Objects.equals(this.targetResource(), other.targetResource());
    }

    public String toString() {
        return ToString.builder((String)"ProgressDetail").add("CurrentProgress", (Object)this.currentProgress()).add("TargetResource", (Object)this.targetResource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "currentProgress": {
                return Optional.ofNullable(clazz.cast(this.currentProgress()));
            }
            case "targetResource": {
                return Optional.ofNullable(clazz.cast(this.targetResource()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProgressDetail, T> g) {
        return obj -> g.apply((ProgressDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currentProgress;
        private String targetResource;

        private BuilderImpl() {
        }

        private BuilderImpl(ProgressDetail model) {
            this.currentProgress(model.currentProgress);
            this.targetResource(model.targetResource);
        }

        public final String getCurrentProgress() {
            return this.currentProgress;
        }

        @Override
        public final Builder currentProgress(String currentProgress) {
            this.currentProgress = currentProgress;
            return this;
        }

        public final void setCurrentProgress(String currentProgress) {
            this.currentProgress = currentProgress;
        }

        public final String getTargetResource() {
            return this.targetResource;
        }

        @Override
        public final Builder targetResource(String targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        public final void setTargetResource(String targetResource) {
            this.targetResource = targetResource;
        }

        public ProgressDetail build() {
            return new ProgressDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProgressDetail> {
        public Builder currentProgress(String var1);

        public Builder targetResource(String var1);
    }
}

