/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.services.robomaker.model.WorldExportJobSummariesCopier;
import software.amazon.awssdk.services.robomaker.model.WorldExportJobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorldExportJobsResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, ListWorldExportJobsResponse> {
    private static final SdkField<List<WorldExportJobSummary>> WORLD_EXPORT_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("worldExportJobSummaries").getter(ListWorldExportJobsResponse.getter(ListWorldExportJobsResponse::worldExportJobSummaries)).setter(ListWorldExportJobsResponse.setter(Builder::worldExportJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldExportJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorldExportJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorldExportJobsResponse.getter(ListWorldExportJobsResponse::nextToken)).setter(ListWorldExportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORLD_EXPORT_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWorldExportJobsResponse.memberNameToFieldInitializer();
    private final List<WorldExportJobSummary> worldExportJobSummaries;
    private final String nextToken;

    private ListWorldExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.worldExportJobSummaries = builder.worldExportJobSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasWorldExportJobSummaries() {
        return this.worldExportJobSummaries != null && !(this.worldExportJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<WorldExportJobSummary> worldExportJobSummaries() {
        return this.worldExportJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorldExportJobSummaries() ? this.worldExportJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorldExportJobsResponse)) {
            return false;
        }
        ListWorldExportJobsResponse other = (ListWorldExportJobsResponse)((Object)obj);
        return this.hasWorldExportJobSummaries() == other.hasWorldExportJobSummaries() && Objects.equals(this.worldExportJobSummaries(), other.worldExportJobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorldExportJobsResponse").add("WorldExportJobSummaries", this.hasWorldExportJobSummaries() ? this.worldExportJobSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "worldExportJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.worldExportJobSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("worldExportJobSummaries", WORLD_EXPORT_JOB_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorldExportJobsResponse, T> g) {
        return obj -> g.apply((ListWorldExportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private List<WorldExportJobSummary> worldExportJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorldExportJobsResponse model) {
            super(model);
            this.worldExportJobSummaries(model.worldExportJobSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<WorldExportJobSummary.Builder> getWorldExportJobSummaries() {
            List<WorldExportJobSummary.Builder> result = WorldExportJobSummariesCopier.copyToBuilder(this.worldExportJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorldExportJobSummaries(Collection<WorldExportJobSummary.BuilderImpl> worldExportJobSummaries) {
            this.worldExportJobSummaries = WorldExportJobSummariesCopier.copyFromBuilder(worldExportJobSummaries);
        }

        @Override
        public final Builder worldExportJobSummaries(Collection<WorldExportJobSummary> worldExportJobSummaries) {
            this.worldExportJobSummaries = WorldExportJobSummariesCopier.copy(worldExportJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worldExportJobSummaries(WorldExportJobSummary ... worldExportJobSummaries) {
            this.worldExportJobSummaries(Arrays.asList(worldExportJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worldExportJobSummaries(Consumer<WorldExportJobSummary.Builder> ... worldExportJobSummaries) {
            this.worldExportJobSummaries(Stream.of(worldExportJobSummaries).map(c -> (WorldExportJobSummary)((WorldExportJobSummary.Builder)WorldExportJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWorldExportJobsResponse build() {
            return new ListWorldExportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorldExportJobsResponse> {
        public Builder worldExportJobSummaries(Collection<WorldExportJobSummary> var1);

        public Builder worldExportJobSummaries(WorldExportJobSummary ... var1);

        public Builder worldExportJobSummaries(Consumer<WorldExportJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

