/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.CommandListCopier;
import software.amazon.awssdk.services.robomaker.model.EnvironmentVariableMapCopier;
import software.amazon.awssdk.services.robomaker.model.PortForwardingConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchConfig> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageName").getter(LaunchConfig.getter(LaunchConfig::packageName)).setter(LaunchConfig.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageName").build()}).build();
    private static final SdkField<String> LAUNCH_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchFile").getter(LaunchConfig.getter(LaunchConfig::launchFile)).setter(LaunchConfig.setter(Builder::launchFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchFile").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("environmentVariables").getter(LaunchConfig.getter(LaunchConfig::environmentVariables)).setter(LaunchConfig.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<PortForwardingConfig> PORT_FORWARDING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("portForwardingConfig").getter(LaunchConfig.getter(LaunchConfig::portForwardingConfig)).setter(LaunchConfig.setter(Builder::portForwardingConfig)).constructor(PortForwardingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portForwardingConfig").build()}).build();
    private static final SdkField<Boolean> STREAM_UI_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("streamUI").getter(LaunchConfig.getter(LaunchConfig::streamUI)).setter(LaunchConfig.setter(Builder::streamUI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamUI").build()}).build();
    private static final SdkField<List<String>> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("command").getter(LaunchConfig.getter(LaunchConfig::command)).setter(LaunchConfig.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD, LAUNCH_FILE_FIELD, ENVIRONMENT_VARIABLES_FIELD, PORT_FORWARDING_CONFIG_FIELD, STREAM_UI_FIELD, COMMAND_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LaunchConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String packageName;
    private final String launchFile;
    private final Map<String, String> environmentVariables;
    private final PortForwardingConfig portForwardingConfig;
    private final Boolean streamUI;
    private final List<String> command;

    private LaunchConfig(BuilderImpl builder) {
        this.packageName = builder.packageName;
        this.launchFile = builder.launchFile;
        this.environmentVariables = builder.environmentVariables;
        this.portForwardingConfig = builder.portForwardingConfig;
        this.streamUI = builder.streamUI;
        this.command = builder.command;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final String launchFile() {
        return this.launchFile;
    }

    public final boolean hasEnvironmentVariables() {
        return this.environmentVariables != null && !(this.environmentVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public final PortForwardingConfig portForwardingConfig() {
        return this.portForwardingConfig;
    }

    public final Boolean streamUI() {
        return this.streamUI;
    }

    public final boolean hasCommand() {
        return this.command != null && !(this.command instanceof SdkAutoConstructList);
    }

    public final List<String> command() {
        return this.command;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVariables() ? this.environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.portForwardingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamUI());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommand() ? this.command() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchConfig)) {
            return false;
        }
        LaunchConfig other = (LaunchConfig)obj;
        return Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.launchFile(), other.launchFile()) && this.hasEnvironmentVariables() == other.hasEnvironmentVariables() && Objects.equals(this.environmentVariables(), other.environmentVariables()) && Objects.equals(this.portForwardingConfig(), other.portForwardingConfig()) && Objects.equals(this.streamUI(), other.streamUI()) && this.hasCommand() == other.hasCommand() && Objects.equals(this.command(), other.command());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchConfig").add("PackageName", (Object)this.packageName()).add("LaunchFile", (Object)this.launchFile()).add("EnvironmentVariables", this.hasEnvironmentVariables() ? this.environmentVariables() : null).add("PortForwardingConfig", (Object)this.portForwardingConfig()).add("StreamUI", (Object)this.streamUI()).add("Command", this.hasCommand() ? this.command() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "launchFile": {
                return Optional.ofNullable(clazz.cast(this.launchFile()));
            }
            case "environmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
            case "portForwardingConfig": {
                return Optional.ofNullable(clazz.cast(this.portForwardingConfig()));
            }
            case "streamUI": {
                return Optional.ofNullable(clazz.cast(this.streamUI()));
            }
            case "command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("packageName", PACKAGE_NAME_FIELD);
        map.put("launchFile", LAUNCH_FILE_FIELD);
        map.put("environmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        map.put("portForwardingConfig", PORT_FORWARDING_CONFIG_FIELD);
        map.put("streamUI", STREAM_UI_FIELD);
        map.put("command", COMMAND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchConfig, T> g) {
        return obj -> g.apply((LaunchConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String packageName;
        private String launchFile;
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();
        private PortForwardingConfig portForwardingConfig;
        private Boolean streamUI;
        private List<String> command = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchConfig model) {
            this.packageName(model.packageName);
            this.launchFile(model.launchFile);
            this.environmentVariables(model.environmentVariables);
            this.portForwardingConfig(model.portForwardingConfig);
            this.streamUI(model.streamUI);
            this.command(model.command);
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getLaunchFile() {
            return this.launchFile;
        }

        public final void setLaunchFile(String launchFile) {
            this.launchFile = launchFile;
        }

        @Override
        public final Builder launchFile(String launchFile) {
            this.launchFile = launchFile;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (this.environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariableMapCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariableMapCopier.copy(environmentVariables);
            return this;
        }

        public final PortForwardingConfig.Builder getPortForwardingConfig() {
            return this.portForwardingConfig != null ? this.portForwardingConfig.toBuilder() : null;
        }

        public final void setPortForwardingConfig(PortForwardingConfig.BuilderImpl portForwardingConfig) {
            this.portForwardingConfig = portForwardingConfig != null ? portForwardingConfig.build() : null;
        }

        @Override
        public final Builder portForwardingConfig(PortForwardingConfig portForwardingConfig) {
            this.portForwardingConfig = portForwardingConfig;
            return this;
        }

        public final Boolean getStreamUI() {
            return this.streamUI;
        }

        public final void setStreamUI(Boolean streamUI) {
            this.streamUI = streamUI;
        }

        @Override
        public final Builder streamUI(Boolean streamUI) {
            this.streamUI = streamUI;
            return this;
        }

        public final Collection<String> getCommand() {
            if (this.command instanceof SdkAutoConstructList) {
                return null;
            }
            return this.command;
        }

        public final void setCommand(Collection<String> command) {
            this.command = CommandListCopier.copy(command);
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = CommandListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String ... command) {
            this.command(Arrays.asList(command));
            return this;
        }

        public LaunchConfig build() {
            return new LaunchConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchConfig> {
        public Builder packageName(String var1);

        public Builder launchFile(String var1);

        public Builder environmentVariables(Map<String, String> var1);

        public Builder portForwardingConfig(PortForwardingConfig var1);

        default public Builder portForwardingConfig(Consumer<PortForwardingConfig.Builder> portForwardingConfig) {
            return this.portForwardingConfig((PortForwardingConfig)((PortForwardingConfig.Builder)PortForwardingConfig.builder().applyMutation(portForwardingConfig)).build());
        }

        public Builder streamUI(Boolean var1);

        public Builder command(Collection<String> var1);

        public Builder command(String ... var1);
    }
}

