/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.services.robomaker.model.TemplateSummariesCopier;
import software.amazon.awssdk.services.robomaker.model.TemplateSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorldTemplatesResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, ListWorldTemplatesResponse> {
    private static final SdkField<List<TemplateSummary>> TEMPLATE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("templateSummaries").getter(ListWorldTemplatesResponse.getter(ListWorldTemplatesResponse::templateSummaries)).setter(ListWorldTemplatesResponse.setter(Builder::templateSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TemplateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorldTemplatesResponse.getter(ListWorldTemplatesResponse::nextToken)).setter(ListWorldTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<TemplateSummary> templateSummaries;
    private final String nextToken;

    private ListWorldTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.templateSummaries = builder.templateSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTemplateSummaries() {
        return this.templateSummaries != null && !(this.templateSummaries instanceof SdkAutoConstructList);
    }

    public final List<TemplateSummary> templateSummaries() {
        return this.templateSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplateSummaries() ? this.templateSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorldTemplatesResponse)) {
            return false;
        }
        ListWorldTemplatesResponse other = (ListWorldTemplatesResponse)((Object)obj);
        return this.hasTemplateSummaries() == other.hasTemplateSummaries() && Objects.equals(this.templateSummaries(), other.templateSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorldTemplatesResponse").add("TemplateSummaries", this.hasTemplateSummaries() ? this.templateSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "templateSummaries": {
                return Optional.ofNullable(clazz.cast(this.templateSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorldTemplatesResponse, T> g) {
        return obj -> g.apply((ListWorldTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private List<TemplateSummary> templateSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorldTemplatesResponse model) {
            super(model);
            this.templateSummaries(model.templateSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<TemplateSummary.Builder> getTemplateSummaries() {
            List<TemplateSummary.Builder> result = TemplateSummariesCopier.copyToBuilder(this.templateSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplateSummaries(Collection<TemplateSummary.BuilderImpl> templateSummaries) {
            this.templateSummaries = TemplateSummariesCopier.copyFromBuilder(templateSummaries);
        }

        @Override
        public final Builder templateSummaries(Collection<TemplateSummary> templateSummaries) {
            this.templateSummaries = TemplateSummariesCopier.copy(templateSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateSummaries(TemplateSummary ... templateSummaries) {
            this.templateSummaries(Arrays.asList(templateSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateSummaries(Consumer<TemplateSummary.Builder> ... templateSummaries) {
            this.templateSummaries(Stream.of(templateSummaries).map(c -> (TemplateSummary)((TemplateSummary.Builder)TemplateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWorldTemplatesResponse build() {
            return new ListWorldTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorldTemplatesResponse> {
        public Builder templateSummaries(Collection<TemplateSummary> var1);

        public Builder templateSummaries(TemplateSummary ... var1);

        public Builder templateSummaries(Consumer<TemplateSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

