/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerAsyncClient;
import software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest;
import software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse;
import software.amazon.awssdk.services.robomaker.model.RobotApplicationSummary;

public class ListRobotApplicationsPublisher
implements SdkPublisher<ListRobotApplicationsResponse> {
    private final RoboMakerAsyncClient client;
    private final ListRobotApplicationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRobotApplicationsPublisher(RoboMakerAsyncClient client, ListRobotApplicationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRobotApplicationsPublisher(RoboMakerAsyncClient client, ListRobotApplicationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRobotApplicationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRobotApplicationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RobotApplicationSummary> robotApplicationSummaries() {
        Function<ListRobotApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.robotApplicationSummaries() != null) {
                return response.robotApplicationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRobotApplicationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRobotApplicationsResponseFetcher
    implements AsyncPageFetcher<ListRobotApplicationsResponse> {
        private ListRobotApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRobotApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRobotApplicationsResponse> nextPage(ListRobotApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListRobotApplicationsPublisher.this.client.listRobotApplications(ListRobotApplicationsPublisher.this.firstRequest);
            }
            return ListRobotApplicationsPublisher.this.client.listRobotApplications((ListRobotApplicationsRequest)((Object)ListRobotApplicationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

