/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.ArnsCopier;
import software.amazon.awssdk.services.robomaker.model.OutputLocation;
import software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorldExportJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorldExportJobSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(WorldExportJobSummary.getter(WorldExportJobSummary::arn)).setter(WorldExportJobSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(WorldExportJobSummary.getter(WorldExportJobSummary::statusAsString)).setter(WorldExportJobSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(WorldExportJobSummary.getter(WorldExportJobSummary::createdAt)).setter(WorldExportJobSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<List<String>> WORLDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("worlds").getter(WorldExportJobSummary.getter(WorldExportJobSummary::worlds)).setter(WorldExportJobSummary.setter(Builder::worlds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worlds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OutputLocation> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputLocation").getter(WorldExportJobSummary.getter(WorldExportJobSummary::outputLocation)).setter(WorldExportJobSummary.setter(Builder::outputLocation)).constructor(OutputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD, CREATED_AT_FIELD, WORLDS_FIELD, OUTPUT_LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String status;
    private final Instant createdAt;
    private final List<String> worlds;
    private final OutputLocation outputLocation;

    private WorldExportJobSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.worlds = builder.worlds;
        this.outputLocation = builder.outputLocation;
    }

    public final String arn() {
        return this.arn;
    }

    public final WorldExportJobStatus status() {
        return WorldExportJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final boolean hasWorlds() {
        return this.worlds != null && !(this.worlds instanceof SdkAutoConstructList);
    }

    public final List<String> worlds() {
        return this.worlds;
    }

    public final OutputLocation outputLocation() {
        return this.outputLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorlds() ? this.worlds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorldExportJobSummary)) {
            return false;
        }
        WorldExportJobSummary other = (WorldExportJobSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && this.hasWorlds() == other.hasWorlds() && Objects.equals(this.worlds(), other.worlds()) && Objects.equals(this.outputLocation(), other.outputLocation());
    }

    public final String toString() {
        return ToString.builder((String)"WorldExportJobSummary").add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("Worlds", this.hasWorlds() ? this.worlds() : null).add("OutputLocation", (Object)this.outputLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "worlds": {
                return Optional.ofNullable(clazz.cast(this.worlds()));
            }
            case "outputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorldExportJobSummary, T> g) {
        return obj -> g.apply((WorldExportJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String status;
        private Instant createdAt;
        private List<String> worlds = DefaultSdkAutoConstructList.getInstance();
        private OutputLocation outputLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(WorldExportJobSummary model) {
            this.arn(model.arn);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.worlds(model.worlds);
            this.outputLocation(model.outputLocation);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(WorldExportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Collection<String> getWorlds() {
            if (this.worlds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.worlds;
        }

        public final void setWorlds(Collection<String> worlds) {
            this.worlds = ArnsCopier.copy(worlds);
        }

        @Override
        @Transient
        public final Builder worlds(Collection<String> worlds) {
            this.worlds = ArnsCopier.copy(worlds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder worlds(String ... worlds) {
            this.worlds(Arrays.asList(worlds));
            return this;
        }

        public final OutputLocation.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        public final void setOutputLocation(OutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public WorldExportJobSummary build() {
            return new WorldExportJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorldExportJobSummary> {
        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(WorldExportJobStatus var1);

        public Builder createdAt(Instant var1);

        public Builder worlds(Collection<String> var1);

        public Builder worlds(String ... var1);

        public Builder outputLocation(OutputLocation var1);

        default public Builder outputLocation(Consumer<OutputLocation.Builder> outputLocation) {
            return this.outputLocation((OutputLocation)((OutputLocation.Builder)OutputLocation.builder().applyMutation(outputLocation)).build());
        }
    }
}

