/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.services.robomaker.model.SimulationApplicationSummariesCopier;
import software.amazon.awssdk.services.robomaker.model.SimulationApplicationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSimulationApplicationsResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, ListSimulationApplicationsResponse> {
    private static final SdkField<List<SimulationApplicationSummary>> SIMULATION_APPLICATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("simulationApplicationSummaries").getter(ListSimulationApplicationsResponse.getter(ListSimulationApplicationsResponse::simulationApplicationSummaries)).setter(ListSimulationApplicationsResponse.setter(Builder::simulationApplicationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationApplicationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SimulationApplicationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSimulationApplicationsResponse.getter(ListSimulationApplicationsResponse::nextToken)).setter(ListSimulationApplicationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIMULATION_APPLICATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<SimulationApplicationSummary> simulationApplicationSummaries;
    private final String nextToken;

    private ListSimulationApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.simulationApplicationSummaries = builder.simulationApplicationSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSimulationApplicationSummaries() {
        return this.simulationApplicationSummaries != null && !(this.simulationApplicationSummaries instanceof SdkAutoConstructList);
    }

    public final List<SimulationApplicationSummary> simulationApplicationSummaries() {
        return this.simulationApplicationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSimulationApplicationSummaries() ? this.simulationApplicationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSimulationApplicationsResponse)) {
            return false;
        }
        ListSimulationApplicationsResponse other = (ListSimulationApplicationsResponse)((Object)obj);
        return this.hasSimulationApplicationSummaries() == other.hasSimulationApplicationSummaries() && Objects.equals(this.simulationApplicationSummaries(), other.simulationApplicationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSimulationApplicationsResponse").add("SimulationApplicationSummaries", this.hasSimulationApplicationSummaries() ? this.simulationApplicationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "simulationApplicationSummaries": {
                return Optional.ofNullable(clazz.cast(this.simulationApplicationSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSimulationApplicationsResponse, T> g) {
        return obj -> g.apply((ListSimulationApplicationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private List<SimulationApplicationSummary> simulationApplicationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSimulationApplicationsResponse model) {
            super(model);
            this.simulationApplicationSummaries(model.simulationApplicationSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<SimulationApplicationSummary.Builder> getSimulationApplicationSummaries() {
            List<SimulationApplicationSummary.Builder> result = SimulationApplicationSummariesCopier.copyToBuilder(this.simulationApplicationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder simulationApplicationSummaries(Collection<SimulationApplicationSummary> simulationApplicationSummaries) {
            this.simulationApplicationSummaries = SimulationApplicationSummariesCopier.copy(simulationApplicationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationApplicationSummaries(SimulationApplicationSummary ... simulationApplicationSummaries) {
            this.simulationApplicationSummaries(Arrays.asList(simulationApplicationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationApplicationSummaries(Consumer<SimulationApplicationSummary.Builder> ... simulationApplicationSummaries) {
            this.simulationApplicationSummaries(Stream.of(simulationApplicationSummaries).map(c -> (SimulationApplicationSummary)((SimulationApplicationSummary.Builder)SimulationApplicationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSimulationApplicationSummaries(Collection<SimulationApplicationSummary.BuilderImpl> simulationApplicationSummaries) {
            this.simulationApplicationSummaries = SimulationApplicationSummariesCopier.copyFromBuilder(simulationApplicationSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSimulationApplicationsResponse build() {
            return new ListSimulationApplicationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSimulationApplicationsResponse> {
        public Builder simulationApplicationSummaries(Collection<SimulationApplicationSummary> var1);

        public Builder simulationApplicationSummaries(SimulationApplicationSummary ... var1);

        public Builder simulationApplicationSummaries(Consumer<SimulationApplicationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

