/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.ArnsCopier;
import software.amazon.awssdk.services.robomaker.model.FailureSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FinishedWorldsSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FinishedWorldsSummary> {
    private static final SdkField<Integer> FINISHED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("finishedCount").getter(FinishedWorldsSummary.getter(FinishedWorldsSummary::finishedCount)).setter(FinishedWorldsSummary.setter(Builder::finishedCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finishedCount").build()}).build();
    private static final SdkField<List<String>> SUCCEEDED_WORLDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("succeededWorlds").getter(FinishedWorldsSummary.getter(FinishedWorldsSummary::succeededWorlds)).setter(FinishedWorldsSummary.setter(Builder::succeededWorlds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("succeededWorlds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FailureSummary> FAILURE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("failureSummary").getter(FinishedWorldsSummary.getter(FinishedWorldsSummary::failureSummary)).setter(FinishedWorldsSummary.setter(Builder::failureSummary)).constructor(FailureSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINISHED_COUNT_FIELD, SUCCEEDED_WORLDS_FIELD, FAILURE_SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer finishedCount;
    private final List<String> succeededWorlds;
    private final FailureSummary failureSummary;

    private FinishedWorldsSummary(BuilderImpl builder) {
        this.finishedCount = builder.finishedCount;
        this.succeededWorlds = builder.succeededWorlds;
        this.failureSummary = builder.failureSummary;
    }

    public final Integer finishedCount() {
        return this.finishedCount;
    }

    public final boolean hasSucceededWorlds() {
        return this.succeededWorlds != null && !(this.succeededWorlds instanceof SdkAutoConstructList);
    }

    public final List<String> succeededWorlds() {
        return this.succeededWorlds;
    }

    public final FailureSummary failureSummary() {
        return this.failureSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.finishedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSucceededWorlds() ? this.succeededWorlds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.failureSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FinishedWorldsSummary)) {
            return false;
        }
        FinishedWorldsSummary other = (FinishedWorldsSummary)obj;
        return Objects.equals(this.finishedCount(), other.finishedCount()) && this.hasSucceededWorlds() == other.hasSucceededWorlds() && Objects.equals(this.succeededWorlds(), other.succeededWorlds()) && Objects.equals(this.failureSummary(), other.failureSummary());
    }

    public final String toString() {
        return ToString.builder((String)"FinishedWorldsSummary").add("FinishedCount", (Object)this.finishedCount()).add("SucceededWorlds", this.hasSucceededWorlds() ? this.succeededWorlds() : null).add("FailureSummary", (Object)this.failureSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "finishedCount": {
                return Optional.ofNullable(clazz.cast(this.finishedCount()));
            }
            case "succeededWorlds": {
                return Optional.ofNullable(clazz.cast(this.succeededWorlds()));
            }
            case "failureSummary": {
                return Optional.ofNullable(clazz.cast(this.failureSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FinishedWorldsSummary, T> g) {
        return obj -> g.apply((FinishedWorldsSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer finishedCount;
        private List<String> succeededWorlds = DefaultSdkAutoConstructList.getInstance();
        private FailureSummary failureSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(FinishedWorldsSummary model) {
            this.finishedCount(model.finishedCount);
            this.succeededWorlds(model.succeededWorlds);
            this.failureSummary(model.failureSummary);
        }

        public final Integer getFinishedCount() {
            return this.finishedCount;
        }

        @Override
        public final Builder finishedCount(Integer finishedCount) {
            this.finishedCount = finishedCount;
            return this;
        }

        public final void setFinishedCount(Integer finishedCount) {
            this.finishedCount = finishedCount;
        }

        public final Collection<String> getSucceededWorlds() {
            if (this.succeededWorlds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.succeededWorlds;
        }

        @Override
        public final Builder succeededWorlds(Collection<String> succeededWorlds) {
            this.succeededWorlds = ArnsCopier.copy(succeededWorlds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder succeededWorlds(String ... succeededWorlds) {
            this.succeededWorlds(Arrays.asList(succeededWorlds));
            return this;
        }

        public final void setSucceededWorlds(Collection<String> succeededWorlds) {
            this.succeededWorlds = ArnsCopier.copy(succeededWorlds);
        }

        public final FailureSummary.Builder getFailureSummary() {
            return this.failureSummary != null ? this.failureSummary.toBuilder() : null;
        }

        @Override
        public final Builder failureSummary(FailureSummary failureSummary) {
            this.failureSummary = failureSummary;
            return this;
        }

        public final void setFailureSummary(FailureSummary.BuilderImpl failureSummary) {
            this.failureSummary = failureSummary != null ? failureSummary.build() : null;
        }

        public FinishedWorldsSummary build() {
            return new FinishedWorldsSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FinishedWorldsSummary> {
        public Builder finishedCount(Integer var1);

        public Builder succeededWorlds(Collection<String> var1);

        public Builder succeededWorlds(String ... var1);

        public Builder failureSummary(FailureSummary var1);

        default public Builder failureSummary(Consumer<FailureSummary.Builder> failureSummary) {
            return this.failureSummary((FailureSummary)((FailureSummary.Builder)FailureSummary.builder().applyMutation(failureSummary)).build());
        }
    }
}

